/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class HierarchicalFilePathComparator
implements Comparator<FilePath> {
    public static final HierarchicalFilePathComparator IGNORE_CASE = new HierarchicalFilePathComparator(true);
    public static final HierarchicalFilePathComparator SYSTEM_CASE_SENSITIVE = new HierarchicalFilePathComparator(!SystemInfo.isFileSystemCaseSensitive);
    private final boolean myIgnoreCase;

    private HierarchicalFilePathComparator(boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
    }

    @Override
    public int compare(@NotNull FilePath filePath1, @NotNull FilePath filePath2) {
        boolean isDirectory2;
        String path2;
        String path1;
        int commonPrefix;
        if (filePath1 == null) {
            HierarchicalFilePathComparator.$$$reportNull$$$0(0);
        }
        if (filePath2 == null) {
            HierarchicalFilePathComparator.$$$reportNull$$$0(1);
        }
        if ((commonPrefix = StringUtil.commonPrefixLength((CharSequence)(path1 = FileUtilRt.toSystemIndependentName((String)filePath1.getPath())), (CharSequence)(path2 = FileUtilRt.toSystemIndependentName((String)filePath2.getPath())), (boolean)this.myIgnoreCase)) == path1.length() && commonPrefix == path2.length()) {
            if (filePath1.isDirectory() != filePath2.isDirectory()) {
                return filePath1.isDirectory() ? -1 : 1;
            }
            return 0;
        }
        if (commonPrefix == path1.length() && path2.charAt(commonPrefix) == '/') {
            return filePath1.isDirectory() ? -1 : 1;
        }
        if (commonPrefix == path2.length() && path1.charAt(commonPrefix) == '/') {
            return filePath2.isDirectory() ? 1 : -1;
        }
        int start2 = StringUtil.lastIndexOf((CharSequence)path1, (char)'/', (int)0, (int)commonPrefix) + 1;
        int end1 = path1.indexOf(47, start2);
        int end2 = path2.indexOf(47, start2);
        String name1 = end1 == -1 ? path1.substring(start2) : path1.substring(start2, end1);
        String name2 = end2 == -1 ? path2.substring(start2) : path2.substring(start2, end2);
        boolean isDirectory1 = end1 != -1 || filePath1.isDirectory();
        boolean bl = isDirectory2 = end2 != -1 || filePath2.isDirectory();
        if (isDirectory1 != isDirectory2) {
            return isDirectory1 ? -1 : 1;
        }
        return StringUtil.compare((String)name1, (String)name2, (boolean)this.myIgnoreCase);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath2";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/HierarchicalFilePathComparator";
        objectArray[2] = "compare";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

