/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesElementFactory {
    private static final UserDataCache<PropertiesFile, Project, Void> PROPERTIES = new UserDataCache<PropertiesFile, Project, Void>("system.properties.file"){

        protected PropertiesFile compute(Project project, Void p) {
            return PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
        }
    };

    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value, @Nullable Character delimiter) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(1);
        }
        if (value == null) {
            PropertiesElementFactory.$$$reportNull$$$0(2);
        }
        String text = PropertiesElementFactory.getPropertyText(name, value, delimiter, project, true);
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile(project, text);
        IProperty iProperty = dummyFile.getProperties().get(0);
        if (iProperty == null) {
            PropertiesElementFactory.$$$reportNull$$$0(3);
        }
        return iProperty;
    }

    @Deprecated
    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(5);
        }
        if (value == null) {
            PropertiesElementFactory.$$$reportNull$$$0(6);
        }
        IProperty iProperty = PropertiesElementFactory.createProperty(project, name, value, null);
        if (iProperty == null) {
            PropertiesElementFactory.$$$reportNull$$$0(7);
        }
        return iProperty;
    }

    @NotNull
    public static String getPropertyText(@NonNls @NotNull String name, @NonNls @NotNull String value, @NonNls @Nullable Character delimiter, @Nullable Project project, boolean escape) {
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(8);
        }
        if (value == null) {
            PropertiesElementFactory.$$$reportNull$$$0(9);
        }
        if (delimiter == null) {
            delimiter = Character.valueOf(project == null ? (char)'=' : PropertiesCodeStyleSettings.getInstance(project).getDelimiter());
        }
        String string = (escape ? PropertiesElementFactory.escape(name) : name) + delimiter + (escape ? PropertiesElementFactory.escapeValue(value, delimiter.charValue()) : value);
        if (string == null) {
            PropertiesElementFactory.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(11);
        }
        if (text == null) {
            PropertiesElementFactory.$$$reportNull$$$0(12);
        }
        String filename = "dummy." + PropertiesFileType.INSTANCE.getDefaultExtension();
        PropertiesFile propertiesFile = (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)text);
        if (propertiesFile == null) {
            PropertiesElementFactory.$$$reportNull$$$0(13);
        }
        return propertiesFile;
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, Properties properties, String fileName) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(14);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            properties.store(stream, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String filename = fileName + "." + PropertiesFileType.INSTANCE.getDefaultExtension();
        PropertiesFile propertiesFile = (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)stream.toString());
        if (propertiesFile == null) {
            PropertiesElementFactory.$$$reportNull$$$0(15);
        }
        return propertiesFile;
    }

    @NotNull
    public static PropertiesFile getSystemProperties(@NotNull Project project) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(16);
        }
        PropertiesFile propertiesFile = (PropertiesFile)PROPERTIES.get((UserDataHolder)project, null);
        if (propertiesFile == null) {
            PropertiesElementFactory.$$$reportNull$$$0(17);
        }
        return propertiesFile;
    }

    @NotNull
    private static String escape(@NotNull String name) {
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(18);
        }
        if (StringUtil.startsWithChar((CharSequence)name, (char)'#') || StringUtil.startsWithChar((CharSequence)name, (char)'!')) {
            name = "\\" + name;
        }
        String string = StringUtil.escapeChars((String)name, (char[])new char[]{'=', ':', ' ', '\t'});
        if (string == null) {
            PropertiesElementFactory.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Deprecated
    public static String escapeValue(String value) {
        return PropertiesElementFactory.escapeValue(value, '=');
    }

    public static String escapeValue(String value, char delimiter) {
        return PropertiesResourceBundleUtil.fromValueEditorToPropertyValue(value, delimiter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/psi/PropertiesElementFactory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/psi/PropertiesElementFactory";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperty";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyText";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertiesFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyText";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSystemProperties";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

