/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import processing.app.SketchCode;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.DebugTree;
import processing.mode.java.pdex.ErrorChecker;
import processing.mode.java.pdex.InspectMode;
import processing.mode.java.pdex.PreprocessingService;
import processing.mode.java.pdex.Rename;
import processing.mode.java.pdex.ShowUsage;

public class PDEX {
    private static final boolean SHOW_DEBUG_TREE = false;
    private boolean enabled = true;
    private ErrorChecker errorChecker;
    private InspectMode inspect;
    private ShowUsage usage;
    private Rename rename;
    private DebugTree debugTree;
    private PreprocessingService pps;
    final DocumentListener sketchChangedListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            PDEX.this.sketchChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PDEX.this.sketchChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PDEX.this.sketchChanged();
        }
    };

    public PDEX(JavaEditor editor, PreprocessingService pps) {
        this.pps = pps;
        this.enabled = !editor.hasJavaTabs();
        this.errorChecker = new ErrorChecker(editor, pps);
        this.usage = new ShowUsage(editor, pps);
        this.inspect = new InspectMode(editor, pps, this.usage);
        this.rename = new Rename(editor, pps, this.usage);
        SketchCode[] sketchCodeArray = editor.getSketch().getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode code = sketchCodeArray[n2];
            Document document = code.getDocument();
            this.addDocumentListener(document);
            ++n2;
        }
        this.sketchChanged();
    }

    public void addDocumentListener(Document doc) {
        if (doc != null) {
            doc.addDocumentListener(this.sketchChangedListener);
        }
    }

    public void sketchChanged() {
        this.errorChecker.notifySketchChanged();
        this.pps.notifySketchChanged();
    }

    public void preferencesChanged() {
        this.errorChecker.preferencesChanged();
        this.sketchChanged();
    }

    public void hasJavaTabsChanged(boolean hasJavaTabs) {
        boolean bl = this.enabled = !hasJavaTabs;
        if (!this.enabled) {
            this.usage.hide();
        }
    }

    public void dispose() {
        this.inspect.dispose();
        this.errorChecker.dispose();
        this.usage.dispose();
        this.rename.dispose();
        if (this.debugTree != null) {
            this.debugTree.dispose();
        }
    }

    public void documentChanged(Document newDoc) {
        this.addDocumentListener(newDoc);
    }
}

