/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.security.MessageDigest;
import java.util.Optional;
import org.bouncycastle.util.Arrays;
import org.sejda.sambox.encryption.ARC4Engine;
import org.sejda.sambox.encryption.EncryptUtils;
import org.sejda.sambox.encryption.EncryptionContext;
import org.sejda.sambox.encryption.MessageDigests;
import org.sejda.sambox.encryption.PasswordAlgorithm;
import org.sejda.sambox.encryption.StandardSecurityHandlerRevision;

class Algorithm3
implements PasswordAlgorithm {
    private MessageDigest digest = MessageDigests.md5();
    private ARC4Engine engine = new ARC4Engine();

    Algorithm3() {
    }

    @Override
    public byte[] computePassword(EncryptionContext context) {
        byte[] ownerBytes = context.security.getOwnerPassword();
        byte[] userBytes = context.security.getUserPassword();
        byte[] padded = EncryptUtils.padOrTruncate(Optional.of(ownerBytes).filter(p -> ((byte[])p).length > 0).orElseGet(() -> userBytes));
        byte[] paddedUser = EncryptUtils.padOrTruncate(userBytes);
        this.digest.reset();
        byte[] arc4Key = this.digest.digest(padded);
        if (StandardSecurityHandlerRevision.R3.compareTo(context.security.encryption.revision) <= 0) {
            for (int i = 0; i < 50; ++i) {
                this.digest.update(arc4Key, 0, context.security.encryption.revision.length);
                arc4Key = Arrays.copyOf((byte[])this.digest.digest(), (int)context.security.encryption.revision.length);
            }
            byte[] encrypted = this.engine.encryptBytes(paddedUser, arc4Key);
            byte[] iterationKey = new byte[arc4Key.length];
            for (int i = 1; i < 20; ++i) {
                iterationKey = Arrays.copyOf((byte[])arc4Key, (int)arc4Key.length);
                for (int j = 0; j < iterationKey.length; ++j) {
                    iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                }
                encrypted = this.engine.encryptBytes(encrypted, iterationKey);
            }
            return encrypted;
        }
        return this.engine.encryptBytes(paddedUser, arc4Key);
    }
}

