/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;

public class GetAttachmentCommand
extends BugtrackingCommand {
    private final TaskAttribute ta;
    private final TaskRepository taskRepository;
    private final AbstractRepositoryConnector repositoryConnector;
    private final OutputStream os;
    private String stringValue;
    private final ITask task;

    GetAttachmentCommand(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, ITask task, TaskAttribute ta, OutputStream os) {
        this.ta = ta;
        this.task = task;
        this.taskRepository = taskRepository;
        this.repositoryConnector = repositoryConnector;
        this.os = os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        AbstractTaskAttachmentHandler taskAttachmentHandler;
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing GetTaskDataCommand for attachment id: {0}", this.ta.getValue());
        }
        if (!(taskAttachmentHandler = this.repositoryConnector.getTaskAttachmentHandler()).canGetContent(this.taskRepository, this.task)) {
            throw new IOException("Cannot get content for attachment with id: " + this.ta.getValue());
        }
        InputStream is = taskAttachmentHandler.getContent(this.taskRepository, this.task, this.ta, (IProgressMonitor)new NullProgressMonitor());
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) != -1) {
                this.os.write(buffer, 0, n);
            }
        }
        finally {
            is.close();
        }
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("GetAttachmentCommand [repository=");
            sb.append(this.taskRepository.getUrl());
            sb.append(",attachmentID=");
            sb.append(this.ta.getValue());
            sb.append("]");
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

