/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.openide.awt.Actions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class RunSQLSelectionAction
extends SQLExecutionBaseAction {
    private static final Logger LOGGER = Logger.getLogger(RunSQLSelectionAction.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String ICON_PATH = "org/netbeans/modules/db/sql/editor/resources/runsql-partial.png";

    @Override
    protected void initialize() {
        this.putValue("Name", NbBundle.getMessage(RunSQLSelectionAction.class, (String)"LBL_RunSQLSelectionAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    protected String getIconBase() {
        return ICON_PATH;
    }

    @Override
    public String getDisplayName(SQLExecution sqlExecution) {
        if (sqlExecution == null || sqlExecution.isSelection()) {
            return NbBundle.getMessage(RunSQLSelectionAction.class, (String)"LBL_RunSelectionAction");
        }
        return NbBundle.getMessage(RunSQLSelectionAction.class, (String)"LBL_RunCurrentStatementAction");
    }

    @Override
    public void actionPerformed(SQLExecution sqlExecution) {
        DatabaseConnection dbconn;
        if (LOG) {
            LOGGER.log(Level.FINE, "actionPerformed for " + sqlExecution);
        }
        if ((dbconn = sqlExecution.getDatabaseConnection()) != null) {
            sqlExecution.executeSelection();
        } else {
            RunSQLSelectionAction.notifyNoDatabaseConnection();
        }
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new SelectionContextAwareDelegate(this, actionContext);
    }

    private static final class SelectionContextAwareDelegate
    extends SQLExecutionBaseAction.ContextAwareDelegate
    implements Presenter.Popup {
        public SelectionContextAwareDelegate(RunSQLSelectionAction parent, Lookup actionContext) {
            super(parent, actionContext);
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.MenuItem((Action)this, false);
        }
    }
}

