/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import javax.servlet.http.Cookie;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.CookieTools;

public class SessionInterceptor
extends BaseInterceptor {
    static final char SESSIONID_ROUTE_SEP = '.';
    ContextManager cm;
    boolean noCookies = false;

    public void setContextManager(ContextManager cm) {
        this.cm = cm;
    }

    public void setNoCookies(boolean noCookies) {
        this.noCookies = noCookies;
    }

    public int contextMap(Request request) {
        if (request.getRequestedSessionId() != null) {
            return 0;
        }
        String sig = ";jsessionid=";
        int foundAt = -1;
        String uri = request.getRequestURI();
        foundAt = uri.indexOf(sig);
        if (foundAt != -1) {
            String sessionId = uri.substring(foundAt + sig.length());
            request.setRequestURI(uri.substring(0, foundAt));
            request.setSessionIdSource("url");
            request.setRequestedSessionId(sessionId);
        }
        return 0;
    }

    public int beforeBody(Request rrequest, Response response) {
        String reqSessionId = response.getSessionId();
        if (this.debug > 0) {
            this.cm.log("Before Body " + reqSessionId);
        }
        if (reqSessionId == null) {
            return 0;
        }
        if (this.noCookies) {
            return 0;
        }
        String sessionPath = rrequest.getContext().getPath();
        if (sessionPath.length() == 0) {
            sessionPath = "/";
        }
        Cookie cookie = new Cookie("JSESSIONID", reqSessionId);
        cookie.setMaxAge(-1);
        cookie.setPath(sessionPath);
        cookie.setVersion(1);
        response.addHeader(CookieTools.getCookieHeaderName(cookie), CookieTools.getCookieHeaderValue(cookie));
        cookie.setVersion(0);
        response.addHeader(CookieTools.getCookieHeaderName(cookie), CookieTools.getCookieHeaderValue(cookie));
        return 0;
    }
}

