/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spring;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;

public class MavenSpringConfigProviderImpl
implements SpringConfigFileLocationProvider,
SpringConfigFileProvider {
    private Project prj;

    public MavenSpringConfigProviderImpl(Project project) {
        this.prj = project;
    }

    public FileObject getLocation() {
        URI[] res;
        FileObject fo;
        NbMavenProject project = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        if ("war".equals(project.getPackagingType()) && (fo = FileUtilities.convertURItoFileObject((URI)project.getWebAppDirectory())) != null) {
            return fo;
        }
        for (URI resource : res = project.getResources(false)) {
            FileObject fo2 = FileUtilities.convertURItoFileObject((URI)resource);
            if (fo2 == null) continue;
            return fo2;
        }
        return null;
    }

    public Set<File> getConfigFiles() {
        URI[] res;
        FileObject fo;
        HashSet<File> result = new HashSet<File>();
        NbMavenProject project = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        if ("war".equals(project.getPackagingType()) && (fo = FileUtilities.convertURItoFileObject((URI)project.getWebAppDirectory())) != null) {
            MavenSpringConfigProviderImpl.addFilesInRoot(fo, result);
        }
        for (URI resource : res = project.getResources(false)) {
            FileObject fo2 = FileUtilities.convertURItoFileObject((URI)resource);
            if (fo2 == null) continue;
            MavenSpringConfigProviderImpl.addFilesInRoot(fo2, result);
        }
        return Collections.unmodifiableSet(result);
    }

    private static void addFilesInRoot(FileObject root, Set<File> result) {
        for (FileObject fo : NbCollections.iterable((Enumeration)root.getChildren(true))) {
            File file;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!"text/x-springconfig+xml".equals(fo.getMIMEType()) || (file = FileUtil.toFile((FileObject)fo)) == null) continue;
            result.add(file);
        }
    }
}

