/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BasePropertiesPanel
extends JPanel {
    MySQLOptions options = MySQLOptions.getDefault();
    DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private String initMessage;
    private DocumentListener docListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            BasePropertiesPanel.this.validatePanel();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BasePropertiesPanel.this.validatePanel();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BasePropertiesPanel.this.validatePanel();
        }
    };
    private JCheckBox chkSavePassword;
    private JLabel labelHost;
    private JLabel labelPassword;
    private JLabel labelPort;
    private JLabel labelUser;
    private JLabel messageLabel;
    private JTextField txtHost;
    private JPasswordField txtPassword;
    private JTextField txtPort;
    private JTextField txtUser;

    private void validatePanel() {
        if (this.descriptor == null) {
            return;
        }
        if (this.initMessage != null && !this.initMessage.isEmpty()) {
            this.messageLabel.setText(this.initMessage);
            this.messageLabel.setToolTipText(this.initMessage);
            this.descriptor.setValid(false);
            this.initMessage = null;
            return;
        }
        String error = null;
        if (this.getHost() == null || this.getHost().length() == 0) {
            error = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_SpecifyHost");
        }
        if (this.getUser() == null || this.getUser().length() == 0) {
            error = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_SpecifyUser");
        }
        if (this.getPort() != null && this.getPort().length() > 0) {
            try {
                Integer.valueOf(this.getPort());
            }
            catch (NumberFormatException nfe) {
                error = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_InvalidPortNumber");
            }
        }
        if (error != null) {
            this.messageLabel.setText(error);
            this.descriptor.setValid(false);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    public BasePropertiesPanel(DatabaseServer server) {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.txtUser.getDocument().addDocumentListener(this.docListener);
        this.txtHost.getDocument().addDocumentListener(this.docListener);
        this.txtPort.getDocument().addDocumentListener(this.docListener);
        this.txtPassword.getDocument().addDocumentListener(this.docListener);
        String user = server.getUser();
        if (user == null || user.equals("")) {
            user = MySQLOptions.getDefaultAdminUser();
        }
        this.txtUser.setText(user);
        String host = server.getHost();
        if (host == null || host.equals("")) {
            host = MySQLOptions.getDefaultHost();
        }
        this.txtHost.setText(host);
        String port = server.getPort();
        if (port == null || port.equals("")) {
            port = MySQLOptions.getDefaultPort();
        }
        this.txtPort.setText(port);
        if (server.isSavePassword()) {
            this.txtPassword.setText(server.getPassword());
        }
        this.chkSavePassword.setSelected(server.isSavePassword());
    }

    String getHost() {
        return this.txtHost.getText().trim();
    }

    String getPassword() {
        return new String(this.txtPassword.getPassword()).trim();
    }

    String getPort() {
        return this.txtPort.getText().trim();
    }

    String getUser() {
        return this.txtUser.getText().trim();
    }

    boolean getSavePassword() {
        return this.chkSavePassword.isSelected();
    }

    void setDialogDescriptor(DialogDescriptor desc) {
        this.descriptor = desc;
        this.validatePanel();
    }

    private void initComponents() {
        this.chkSavePassword = new JCheckBox();
        this.messageLabel = new JLabel();
        this.txtHost = new JTextField();
        this.labelHost = new JLabel();
        this.labelPort = new JLabel();
        this.txtPort = new JTextField();
        this.labelUser = new JLabel();
        this.txtUser = new JTextField();
        this.labelPassword = new JLabel();
        this.txtPassword = new JPasswordField();
        this.setAutoscrolls(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkSavePassword, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.text"));
        this.chkSavePassword.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.AccessibleContext.accessibleDescription"));
        this.chkSavePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasePropertiesPanel.this.chkSavePasswordActionPerformed(evt);
            }
        });
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getBundle(BasePropertiesPanel.class).getString("BasePropertiesPanel.messageLabel.text"));
        this.txtHost.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtHost.text"));
        this.txtHost.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtHost.AccessibleContext.accessibleDescription"));
        this.labelHost.setLabelFor(this.txtHost);
        Mnemonics.setLocalizedText((JLabel)this.labelHost, (String)NbBundle.getBundle(BasePropertiesPanel.class).getString("BasePropertiesPanel.labelHost.text"));
        this.labelPort.setLabelFor(this.txtPort);
        Mnemonics.setLocalizedText((JLabel)this.labelPort, (String)NbBundle.getBundle(BasePropertiesPanel.class).getString("BasePropertiesPanel.labelPort.text"));
        this.txtPort.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPort.text"));
        this.txtPort.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPort.AccessibleContext.accessibleDescription"));
        this.labelUser.setLabelFor(this.txtUser);
        Mnemonics.setLocalizedText((JLabel)this.labelUser, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.labelUser.text"));
        this.txtUser.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtUser.text"));
        this.txtUser.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtUser.AccessibleContext.accessibleDescription"));
        this.labelPassword.setLabelFor(this.txtPassword);
        Mnemonics.setLocalizedText((JLabel)this.labelPassword, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.labelPassword.text"));
        this.txtPassword.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPassword.text"));
        this.txtPassword.setToolTipText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPassword.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelHost, -1, -1, Short.MAX_VALUE).addComponent(this.labelPort, -1, -1, Short.MAX_VALUE).addComponent(this.labelPassword, -1, -1, Short.MAX_VALUE).addComponent(this.labelUser)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtUser, -1, 505, Short.MAX_VALUE).addComponent(this.txtPort, -1, 505, Short.MAX_VALUE).addComponent(this.txtPassword, GroupLayout.Alignment.TRAILING, -1, 505, Short.MAX_VALUE).addComponent(this.txtHost, -1, 505, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.chkSavePassword, -1, 684, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -2, 696, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelHost).addComponent(this.txtHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPort, -2, -1, -2).addComponent(this.labelPort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelUser).addComponent(this.txtUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelPassword).addComponent(this.txtPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkSavePassword).addGap(12, 12, 12).addComponent(this.messageLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.chkSavePassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.AccessibleContext.accessibleDescription"));
    }

    private void chkSavePasswordActionPerformed(ActionEvent evt) {
    }

    void setErrorMessage(String msg) {
        this.initMessage = msg;
    }
}

