/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.netbeans.installer.utils.FileUtils;

public class FileEntry {
    private File file;
    private String name;
    private boolean metaDataReady;
    private boolean directory;
    private boolean empty;
    private long size;
    private String md5;
    private boolean jar;
    private boolean packed;
    private boolean signed;
    private long modified;
    private int permissions;

    public FileEntry(File file) {
        this.file = file;
        this.name = file.getAbsolutePath().replace("\\", "/");
        this.metaDataReady = false;
    }

    public FileEntry(File file, boolean empty, long modified, int permissions) {
        this(file);
        this.directory = true;
        this.empty = empty;
        this.modified = modified;
        this.permissions = permissions;
        this.metaDataReady = true;
    }

    public FileEntry(File file, long size, String md5, boolean jar, boolean packed, boolean signed, long modified, int permissions) {
        this(file);
        this.directory = false;
        this.size = size;
        this.md5 = md5;
        this.jar = jar;
        this.packed = packed;
        this.signed = signed;
        this.modified = modified;
        this.permissions = permissions;
        this.metaDataReady = true;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isMetaDataReady() {
        return this.metaDataReady;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public long getSize() {
        return this.size;
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean isJarFile() {
        return this.jar;
    }

    public boolean isPackedJarFile() {
        return this.packed;
    }

    public boolean isSignedJarFile() {
        return this.signed;
    }

    public long getLastModified() {
        return this.modified;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public String toString() {
        if (this.directory) {
            return this.name + "\n" + this.directory + "\n" + this.empty + "\n" + this.modified + "\n" + Integer.toString(this.permissions, 8) + "\n";
        }
        return this.name + "\n" + this.directory + "\n" + this.size + "\n" + this.md5 + "\n" + this.jar + "\n" + this.packed + "\n" + this.signed + "\n" + this.modified + "\n" + Integer.toString(this.permissions, 8) + "\n";
    }

    private String escapeXmlTags(String str) {
        return str == null ? null : str.replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public String toXml() {
        if (this.directory) {
            return "<entry type=\"directory\" empty=\"" + this.empty + "\" modified=\"" + this.modified + "\" permissions=\"" + Integer.toString(this.permissions, 8) + "\">" + this.escapeXmlTags(this.name) + "</entry>";
        }
        return "<entry type=\"file\" size=\"" + this.size + "\" md5=\"" + this.md5 + "\" jar=\"" + this.jar + "\" packed=\"" + this.packed + "\" signed=\"" + this.signed + "\" modified=\"" + this.modified + "\" permissions=\"" + Integer.toString(this.permissions, 8) + "\">" + this.escapeXmlTags(this.name) + "</entry>";
    }

    public void calculateMetaData() throws IOException {
        if (this.file.exists()) {
            this.directory = this.file.isDirectory();
            if (!this.directory) {
                this.size = this.file.length();
                this.md5 = FileUtils.getMd5(this.file);
                this.jar = FileUtils.isJarFile(this.file);
                if (this.jar) {
                    this.packed = false;
                    this.signed = FileUtils.isSigned(this.file);
                }
            } else {
                this.empty = FileUtils.isEmpty(this.file);
            }
        } else {
            throw new FileNotFoundException(this.file.getAbsolutePath());
        }
        this.modified = this.file.lastModified();
        this.metaDataReady = true;
    }
}

