# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.structured_grid_algorithm import StructuredGridAlgorithm


class SegY2DReader(StructuredGridAlgorithm):
    """
    SegY2DReader - no description provided.
    
    Superclass: StructuredGridAlgorithm
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSegY2DReader, obj, update, **traits)
    
    xy_coord_mode = tvtk_base.false_bool_trait(desc=\
        """
        Specify whether to use source x/y coordinates or CDP coordinates
        or custom byte positions for data position in the SEG-Y trace
        header. Defaults to source x/y coordinates.
        
        As per SEG-Y rev 2.0 specification, Source XY coordinate bytes =
        (73, 77) CDP XY coordinate bytes = (181, 185)
        """
    )

    def _xy_coord_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXYCoordMode,
                        self.xy_coord_mode_)

    vertical_crs = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Specify whether the vertical coordinates in the SEG-Y file are
        heights (positive up) or depths (positive down). By default, the
        vertical coordinates are treated as heights (i.e. positive up).
        This means that the Z-axis of the dataset goes from 0 (surface)
        to -ve depth (last sample).
        
        ote As per the SEG-Y rev 2.0 specification, this information is
        defined in the Location Data Stanza of the Extended Textual
        Header. However, as of this revision, SegY2DReader does not
        support reading the extended textual header.
        """
    )

    def _vertical_crs_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVerticalCRS,
                        self.vertical_crs)

    x_coord_byte = traits.Int(73, enter_set=True, auto_set=False, desc=\
        """
        Specify X and Y byte positions for custom xy_coordinate_mode. By
        default, x_coord_byte = 73, y_coord_byte = 77 i.e. source xy.
        
        \sa set_xy_coordinates_mode_to_custom()
        """
    )

    def _x_coord_byte_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXCoordByte,
                        self.x_coord_byte)

    y_coord_byte = traits.Int(77, enter_set=True, auto_set=False, desc=\
        """
        Specify X and Y byte positions for custom xy_coordinate_mode. By
        default, x_coord_byte = 73, y_coord_byte = 77 i.e. source xy.
        
        \sa set_xy_coordinates_mode_to_custom()
        """
    )

    def _y_coord_byte_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetYCoordByte,
                        self.y_coord_byte)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_xy_coord_mode_max_value(self):
        return self._vtk_obj.GetXYCoordModeMaxValue()
    xy_coord_mode_max_value = traits.Property(_get_xy_coord_mode_max_value, desc=\
        """
        Specify whether to use source x/y coordinates or CDP coordinates
        or custom byte positions for data position in the SEG-Y trace
        header. Defaults to source x/y coordinates.
        
        As per SEG-Y rev 2.0 specification, Source XY coordinate bytes =
        (73, 77) CDP XY coordinate bytes = (181, 185)
        """
    )

    def _get_xy_coord_mode_min_value(self):
        return self._vtk_obj.GetXYCoordModeMinValue()
    xy_coord_mode_min_value = traits.Property(_get_xy_coord_mode_min_value, desc=\
        """
        Specify whether to use source x/y coordinates or CDP coordinates
        or custom byte positions for data position in the SEG-Y trace
        header. Defaults to source x/y coordinates.
        
        As per SEG-Y rev 2.0 specification, Source XY coordinate bytes =
        (73, 77) CDP XY coordinate bytes = (181, 185)
        """
    )

    def set_file_name(self, *args):
        """
        V.set_file_name(string)
        C++: virtual void SetFileName(const char *_arg)"""
        ret = self._wrap_call(self._vtk_obj.SetFileName, *args)
        return ret

    def set_xy_coord_mode_to_cdp(self):
        """
        V.set_xy_coord_mode_to_cdp()
        C++: void SetXYCoordModeToCDP()
        Specify whether to use source x/y coordinates or CDP coordinates
        or custom byte positions for data position in the SEG-Y trace
        header. Defaults to source x/y coordinates.
        
        As per SEG-Y rev 2.0 specification, Source XY coordinate bytes =
        (73, 77) CDP XY coordinate bytes = (181, 185)
        """
        ret = self._vtk_obj.SetXYCoordModeToCDP()
        return ret
        

    def set_xy_coord_mode_to_custom(self):
        """
        V.set_xy_coord_mode_to_custom()
        C++: void SetXYCoordModeToCustom()
        Specify whether to use source x/y coordinates or CDP coordinates
        or custom byte positions for data position in the SEG-Y trace
        header. Defaults to source x/y coordinates.
        
        As per SEG-Y rev 2.0 specification, Source XY coordinate bytes =
        (73, 77) CDP XY coordinate bytes = (181, 185)
        """
        ret = self._vtk_obj.SetXYCoordModeToCustom()
        return ret
        

    def set_xy_coord_mode_to_source(self):
        """
        V.set_xy_coord_mode_to_source()
        C++: void SetXYCoordModeToSource()
        Specify whether to use source x/y coordinates or CDP coordinates
        or custom byte positions for data position in the SEG-Y trace
        header. Defaults to source x/y coordinates.
        
        As per SEG-Y rev 2.0 specification, Source XY coordinate bytes =
        (73, 77) CDP XY coordinate bytes = (181, 185)
        """
        ret = self._vtk_obj.SetXYCoordModeToSource()
        return ret
        

    _updateable_traits_ = \
    (('xy_coord_mode', 'GetXYCoordMode'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('vertical_crs', 'GetVerticalCRS'),
    ('x_coord_byte', 'GetXCoordByte'), ('y_coord_byte', 'GetYCoordByte'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'xy_coord_mode', 'progress_text', 'vertical_crs',
    'x_coord_byte', 'y_coord_byte'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SegY2DReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SegY2DReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['xy_coord_mode'], [], ['vertical_crs', 'x_coord_byte',
            'y_coord_byte']),
            title='Edit SegY2DReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SegY2DReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

