/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.BS;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.C;
import org.jmol.util.MeshSurface;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;
    private boolean isAll;
    private boolean frontOnly;
    private boolean edgesOnly;
    private P3[] screens3f;
    private P3i scrVib;
    private boolean vibs;
    private BS bsSelected;
    private boolean showNumbers;
    private MeshSurface meshSurface;

    @Override
    protected boolean render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedron[] polyhedronArray = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        this.bsSelected = this.vwr.getSelectionHalosEnabled() ? this.vwr.bsA() : null;
        this.g3d.addRenderer(1073742182);
        this.vibs = this.ms.vibrations != null && this.tm.vibrationOn;
        this.showNumbers = this.vwr.getBoolean(603979964);
        boolean bl = false;
        int n = polyhedra.polyhedronCount;
        while (--n >= 0) {
            if (!polyhedronArray[n].isValid || !this.render1(polyhedronArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean render1(Polyhedron polyhedron) {
        Object object;
        Object object2;
        Object object3;
        T3[] t3Array;
        short s;
        if (polyhedron.visibilityFlags == 0) {
            return false;
        }
        short[] sArray = ((Polyhedra)this.shape).colixes;
        int n = -1;
        float f = 1.0f;
        if (polyhedron.id == null) {
            n = polyhedron.centralAtom.i;
            s = sArray == null || n >= sArray.length ? (short)0 : sArray[n];
            s = C.getColixInherited(s, polyhedron.centralAtom.colixAtom);
        } else {
            s = polyhedron.colix;
            f = polyhedron.scale;
        }
        boolean bl = false;
        if (C.renderPass2(s)) {
            bl = true;
        } else if (!this.g3d.setC(s)) {
            return false;
        }
        T3[] t3Array2 = polyhedron.vertices;
        if (f != 1.0f) {
            t3Array = new T3[t3Array2.length];
            if (f < 0.0f) {
                object3 = V3.newV(polyhedron.center);
                ((T3)object3).scale(-f - 1.0f);
                int n2 = t3Array.length;
                while (--n2 >= 0) {
                    V3 v3 = V3.newV(t3Array2[n2]);
                    v3.add((T3)object3);
                    t3Array[n2] = v3;
                }
            } else {
                int n3 = t3Array.length;
                while (--n3 >= 0) {
                    V3 v3 = V3.newVsub(t3Array2[n3], polyhedron.center);
                    v3.scaleAdd2(f, v3, polyhedron.center);
                    t3Array[n3] = v3;
                }
            }
            t3Array2 = t3Array;
        }
        if (this.screens3f == null || this.screens3f.length < t3Array2.length) {
            this.screens3f = new P3[t3Array2.length];
            int n4 = t3Array2.length;
            while (--n4 >= 0) {
                this.screens3f[n4] = new P3();
            }
        }
        t3Array = this.screens3f;
        object3 = polyhedron.triangles;
        int[] nArray = polyhedron.pointScale > 0.0f ? polyhedron.getElemNos() : null;
        int n5 = t3Array2.length;
        while (--n5 >= 0) {
            object2 = t3Array2[n5] instanceof Atom ? (Atom)t3Array2[n5] : null;
            T3 t3 = t3Array[n5];
            if (object2 == null) {
                this.tm.transformPtScrT3(t3Array2[n5], t3);
            } else if (this.vibs && ((Atom)object2).hasVibration()) {
                this.scrVib = this.tm.transformPtVib((P3)object2, this.ms.vibrations[((Atom)object2).i]);
                t3.set(this.scrVib.x, this.scrVib.y, this.scrVib.z);
            } else {
                this.tm.transformPt3f((T3)object2, (P3)t3);
            }
            if (nArray != null && n5 < nArray.length && this.g3d.setC(nArray[n5] < 0 ? s : (short)this.vwr.cm.setElementArgb(nArray[n5], Integer.MAX_VALUE))) {
                this.g3d.fillSphereBits((int)this.tm.scaleToScreen((int)((P3)t3).z, (int)(polyhedron.pointScale * 1000.0f)), (P3)t3);
                this.g3d.setC(s);
            }
            if (!this.showNumbers || !this.g3d.setC((short)4)) continue;
            this.g3d.drawStringNoSlab("" + n5, null, (int)((P3)t3).x, (int)((P3)t3).y, (int)((P3)t3).z - 30, (short)0);
            this.g3d.setC(s);
        }
        n5 = n >= 0 && this.bsSelected != null && this.bsSelected.get(n) ? 1 : 0;
        this.isAll = this.drawEdges == 1 || n5 != 0;
        this.frontOnly = this.drawEdges == 2;
        this.edgesOnly = this.drawEdges == 3;
        object2 = polyhedron.getNormixes();
        if (!(bl && !this.g3d.setC(s) || this.edgesOnly)) {
            if (this.exportType == 1 && !polyhedron.collapsed) {
                if (this.meshSurface == null) {
                    this.meshSurface = new MeshSurface();
                }
                this.meshSurface.vs = t3Array2;
                this.meshSurface.pis = (int[][])object3;
                this.meshSurface.pc = ((Object)object3).length;
                this.meshSurface.vc = t3Array2.length;
                this.g3d.drawSurface(this.meshSurface, s);
            } else {
                int n6 = ((Object)object3).length;
                while (--n6 >= 0) {
                    object = object3[n6];
                    try {
                        if (this.showNumbers && !this.g3d.setC((short)(Math.round(Math.random() * 10.0) + 5L))) continue;
                        this.g3d.fillTriangleTwoSided((short)object2[n6], (P3)t3Array[object[0]], (P3)t3Array[object[1]], (P3)t3Array[object[2]]);
                    }
                    catch (Exception exception) {
                        System.out.println("PolyhedraRendererError");
                    }
                }
            }
        }
        if (this.isAll || this.frontOnly || this.edgesOnly) {
            if (n5 != 0) {
                s = 23;
            } else if (polyhedron.colixEdge != 0) {
                s = polyhedron.colixEdge;
            }
            if (this.g3d.setC(C.getColixTranslucent3(s, false, 0.0f))) {
                int n7 = ((Object)object3).length;
                while (--n7 >= 0) {
                    object = object3[n7];
                    this.drawEdges((short)object2[n7], (P3)t3Array[object[0]], (P3)t3Array[object[1]], (P3)t3Array[object[2]], (int)(-object[3]));
                }
            }
        }
        return bl;
    }

    private void drawEdges(short s, P3 p3, P3 p32, P3 p33, int n) {
        if (this.isAll || this.edgesOnly || this.frontOnly && this.vwr.gdata.isDirectedTowardsCamera(s)) {
            int n2;
            int n3 = n2 = this.g3d.isAntialiased() ? 6 : 3;
            if ((n & 1) == 1) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p32);
            }
            if ((n & 2) == 2) {
                this.g3d.fillCylinderBits((byte)3, n2, p32, p33);
            }
            if ((n & 4) == 4) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p33);
            }
        }
    }
}

