#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: graphviz
version: 2999.20.0.3
id: graphviz-2999.20.0.3-Jy0bWqy0r1LDMK40fLPnw
key: graphviz-2999.20.0.3-Jy0bWqy0r1LDMK40fLPnw
license: BSD-3-Clause
copyright: Matthew Sackman, Ivan Lazar Miljenovic
maintainer: Ivan.Miljenovic@gmail.com
author: Matthew Sackman, Ivan Lazar Miljenovic
stability: Beta
homepage: http://projects.haskell.org/graphviz/
synopsis: Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.
    .
    Main features of the graphviz library include:
    .
    * Almost complete coverage of all Graphviz attributes and syntax.
    .
    * Support for specifying clusters.
    .
    * The ability to use a custom node type.
    .
    * Functions for running a Graphviz layout tool with all specified
    output types.
    .
    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).
    .
    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.
    .
    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.
category: Graphs, Graphics
abi: 56be2fa84535fde9b78276de16b5e0fa
exposed: True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic
hidden-modules: Data.GraphViz.Algorithms.Clustering
                Data.GraphViz.Attributes.Arrows
                Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
                Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
                Data.GraphViz.Types.State
import-dirs: /usr/lib/ghc-8.6.5/site-local/graphviz-2999.20.0.3
library-dirs: /usr/lib/ghc-8.6.5/site-local/graphviz-2999.20.0.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/graphviz-2999.20.0.3
hs-libraries: HSgraphviz-2999.20.0.3-Jy0bWqy0r1LDMK40fLPnw
depends:
    base-4.12.0.0 bytestring-0.10.8.2
    colour-2.3.4-BYzTQyKoQ9LK29pbkBo2SY containers-0.6.0.1
    directory-1.3.3.0 dlist-0.8.0.6-CQRMCGRgL5B3ZxhntX4iOr
    fgl-5.7.0.1-9jDJi7QGXmIDO03XSi8vG5 filepath-1.4.2.1 mtl-2.2.2
    polyparse-1.12.1-FeZxex5koKh2BIaglzjzIj process-1.6.5.0
    temporary-1.3-2R9bhTuduqsDRv55IV8XfU text-1.2.3.1
    wl-pprint-text-1.2.0.0-L6i9Q0yxJZoBCBd4YxCMOZ
haddock-interfaces: /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html: /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

