/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import java.io.File;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Transformer;
import org.gradle.internal.composite.DefaultGradleParticipantBuild;
import org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.connection.GradleConnection;
import org.gradle.tooling.connection.GradleConnectionBuilder;
import org.gradle.tooling.internal.connection.GradleConnectionBuilderInternal;
import org.gradle.tooling.internal.connection.GradleConnectionFactory;
import org.gradle.tooling.internal.consumer.DefaultCompositeConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GradleVersion;
import org.gradle.util.SingleMessageLogger;

public class DefaultGradleConnectionBuilder
implements GradleConnectionBuilderInternal {
    private static final String WARNING_MESSAGE = "   - All participant builds will be executed in a single daemon process.\n   - Java home settings for participants will be ignored.\n   - Immutable JVM arguments (e.g. memory settings) will be ignored.\n";
    private final Set<DefaultGradleConnectionParticipantBuilder> participantBuilders = Sets.newLinkedHashSet();
    private final GradleConnectionFactory gradleConnectionFactory;
    private final DistributionFactory distributionFactory;
    private File gradleUserHomeDir;
    private Integer daemonMaxIdleTimeValue;
    private TimeUnit daemonMaxIdleTimeUnits;
    private File daemonBaseDir;
    private boolean integrated;
    private boolean embedded;
    private Distribution coordinatorDistribution;

    public DefaultGradleConnectionBuilder(GradleConnectionFactory gradleConnectionFactory, DistributionFactory distributionFactory) {
        this.gradleConnectionFactory = gradleConnectionFactory;
        this.distributionFactory = distributionFactory;
    }

    public GradleConnectionBuilder.ParticipantBuilder addParticipant(File projectDirectory) {
        DefaultGradleConnectionParticipantBuilder participantBuilder = new DefaultGradleConnectionParticipantBuilder(projectDirectory);
        this.participantBuilders.add(participantBuilder);
        return participantBuilder;
    }

    public GradleConnection build() throws GradleConnectionException {
        if (this.participantBuilders.isEmpty()) {
            throw new IllegalStateException("At least one participant must be specified before creating a connection.");
        }
        return this.createGradleConnection();
    }

    private GradleConnection createGradleConnection() {
        Set<GradleParticipantBuild> participants = CollectionUtils.collect(this.participantBuilders, new Transformer<GradleParticipantBuild, DefaultGradleConnectionParticipantBuilder>(){

            @Override
            public GradleParticipantBuild transform(DefaultGradleConnectionParticipantBuilder participantBuilder) {
                return participantBuilder.build();
            }
        });
        DefaultCompositeConnectionParameters.Builder compositeConnectionParametersBuilder = DefaultCompositeConnectionParameters.builder();
        compositeConnectionParametersBuilder.setBuilds(participants);
        compositeConnectionParametersBuilder.setGradleUserHomeDir(this.gradleUserHomeDir);
        compositeConnectionParametersBuilder.setDaemonMaxIdleTimeValue(this.daemonMaxIdleTimeValue);
        compositeConnectionParametersBuilder.setDaemonMaxIdleTimeUnits(this.daemonMaxIdleTimeUnits);
        compositeConnectionParametersBuilder.setDaemonBaseDir(this.daemonBaseDir);
        if (this.integrated) {
            compositeConnectionParametersBuilder.setEmbedded(this.embedded);
            DefaultCompositeConnectionParameters connectionParameters = compositeConnectionParametersBuilder.build();
            SingleMessageLogger.incubatingFeatureUsed("Integrated composite build", WARNING_MESSAGE);
            Distribution distribution = this.coordinatorDistribution;
            if (distribution == null) {
                distribution = this.distributionFactory.getDistribution(GradleVersion.current().getVersion());
            }
            return this.gradleConnectionFactory.create(distribution, connectionParameters, true);
        }
        DefaultCompositeConnectionParameters connectionParameters = compositeConnectionParametersBuilder.build();
        return this.gradleConnectionFactory.create(this.distributionFactory.getClasspathDistribution(), connectionParameters, false);
    }

    public GradleConnectionBuilder useGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        return this;
    }

    public GradleConnectionBuilderInternal daemonMaxIdleTime(int timeoutValue, TimeUnit timeoutUnits) {
        this.daemonMaxIdleTimeValue = timeoutValue;
        this.daemonMaxIdleTimeUnits = timeoutUnits;
        return this;
    }

    public GradleConnectionBuilderInternal daemonBaseDir(File daemonBaseDir) {
        this.daemonBaseDir = daemonBaseDir;
        return this;
    }

    public GradleConnectionBuilderInternal integratedComposite(boolean integrated) {
        this.integrated = integrated;
        return this;
    }

    public GradleConnectionBuilderInternal embedded(boolean embedded) {
        this.embedded = embedded;
        return this;
    }

    public GradleConnectionBuilder useInstallation(File gradleHome) {
        this.coordinatorDistribution = this.distributionFactory.getDistribution(gradleHome);
        return this;
    }

    public GradleConnectionBuilder useGradleVersion(String gradleVersion) {
        this.coordinatorDistribution = this.distributionFactory.getDistribution(gradleVersion);
        return this;
    }

    public GradleConnectionBuilderInternal useClasspathDistribution() {
        this.coordinatorDistribution = this.distributionFactory.getClasspathDistribution();
        return this;
    }

    private class DefaultGradleConnectionParticipantBuilder
    implements GradleConnectionBuilder.ParticipantBuilder {
        private final File projectDir;
        private File gradleHome;
        private URI gradleDistribution;
        private String gradleVersion;

        public DefaultGradleConnectionParticipantBuilder(File projectDir) {
            if (projectDir == null) {
                throw new IllegalArgumentException("Project directory cannot be null.");
            }
            this.projectDir = projectDir;
        }

        public GradleConnectionBuilder.ParticipantBuilder useBuildDistribution() {
            this.resetDistribution();
            return this;
        }

        public GradleConnectionBuilder.ParticipantBuilder useInstallation(File gradleHome) {
            this.resetDistribution();
            this.gradleHome = gradleHome;
            return this;
        }

        public GradleConnectionBuilder.ParticipantBuilder useGradleVersion(String gradleVersion) {
            this.resetDistribution();
            this.gradleVersion = gradleVersion;
            return this;
        }

        public GradleConnectionBuilder.ParticipantBuilder useDistribution(URI gradleDistribution) {
            this.resetDistribution();
            this.gradleDistribution = gradleDistribution;
            return this;
        }

        public GradleParticipantBuild build() {
            return new DefaultGradleParticipantBuild(this.projectDir, this.gradleHome, this.gradleDistribution, this.gradleVersion);
        }

        private void resetDistribution() {
            this.gradleHome = null;
            this.gradleDistribution = null;
            this.gradleVersion = null;
        }
    }
}

