/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.FileIntegrityViolationException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockTimeoutException;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;

public class OnDemandFileAccess
extends AbstractFileAccess {
    private final String displayName;
    private final FileLockManager manager;
    private final File targetFile;

    public OnDemandFileAccess(File targetFile, String displayName, FileLockManager manager) {
        this.targetFile = targetFile;
        this.displayName = displayName;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException {
        try (FileLock lock = this.manager.lock(this.targetFile, LockOptionsBuilder.mode(FileLockManager.LockMode.Shared), this.displayName);){
            T t = lock.readFile(action);
            return t;
        }
    }

    @Override
    public void updateFile(Runnable action) throws LockTimeoutException, FileIntegrityViolationException {
        try (FileLock lock = this.manager.lock(this.targetFile, LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive), this.displayName);){
            lock.updateFile(action);
        }
    }

    @Override
    public void writeFile(Runnable action) throws LockTimeoutException {
        try (FileLock lock = this.manager.lock(this.targetFile, LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive), this.displayName);){
            lock.writeFile(action);
        }
    }
}

