#############################################################################
##
#W  epifromfpgrouptocollatzgroup_c.g     GAP4 Package `RCWA'      Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing an epimorphism
##  from a finitely presented group to the "Collatz group"
##  G_C = <(1(2),4(6)),(1(3),2(6)),(2(3),4(6))>. The group G_C acts transi-
##  tively on N\0(6) if an only if the Collatz conjecture holds.
##
#############################################################################

local  phi, G_C, H, rels, F, a, b, c;

F := FreeGroup("a","b","c");
a := F.1;; b := F.2;; c := F.3;;

rels :=
[ a^2, b^2, c^2, (a*b)^12, ((a*b*c*a*c*b)^2*(a*(b*c)^2*b)^2)^2, (a*b*c*b)^12, (a*b*a*(b*a*(b*c)^2)^4)^2, ((a*b)^2*a*(c*b*a*b)^3*c)^3, (a*b)^2*a*(b*c*b*a*b*c)^2*b*(c*b*a)^2*b*c*(a*(b*c)^2*b)^2*a*b*c*(b*a)^3*(c*b)^2*a*(b*c)^2, 
  (a*b*c*a*c*b*a*b*c*a*(c*b*a*(b*c)^2*b)^2*c*b)^2, (a*b*c*a*(c*b)^2*a*(b*c)^2*a*(c*b*a*b*c*b)^2*c*b)^2, a*b*a*(b*a*(b*c)^2)^2*(b*a)^3*c*b*a*(b*(c*b*a)^2*b*c)^2*a*(b*c)^2*b*(a*b*c)^2*b*a*b*c, 
  (a*b)^2*a*c*b*a*b*c*b*a*(b*c*b*a*b*c)^4*a*b*c*b*a*b*c*a*b*a*(c*b*a*b)^3*c*b, a*b*a*((b*a*b*c)^2*(b*a)^3*c*b*a*b*c)^2*a*b*a*(b*a*b*c)^4, a*(b*a*b*c)^2*b*a*(b*c*b*a*b*c*(a*b*c*b)^2*a*c*b*a*b*c)^2*(b*a*b*c)^2*b, 
  (a*b)^3*a*(b*c*b*a*b*c)^4*a*b*a*(b*a*c*b*a*b*c)^2*(b*c*b*a*b*c)^2, a*b*a*(b*c*b*a*b*c)^4*a*b*a*c*b*a*b*c*a*b*a*(c*b*a*b*c*b)^4*a*b*a*c*b*a*b*c, (a*b)^2*a*c*(b*c*b*a)^2*(c*b*a*b*c*b)^2*c*b*a*b*(c*a)^2*b*a*(b*c*b*a*(b*c)^2)^2*b*c*b*a*b*c*(a*(b*c)^2*b)^2,
  (a*b)^2*a*(c*b*a*(b*c)^2*b)^2*c*b*(a*b*c)^2*b*c*b*a*(b*c)^2*a*b*a*(c*b*a*b)^2*c*b*a*(c*b*a*b*c*b)^3*c, a*b*a*(b*a*b*c)^2*(b*a)^2*c*b*a*b*c*a*(b*a*b*c)^4*a*(c*b*a*b)^4*a*c*b*a*b*c*a*(b*a*b*c)^2*b, ((a*b)^4*a*(b*c*b*a*b*c)^3*(a*b*c*b)^2)^2, 
  (a*b)^2*a*c*b*a*b*c*a*((b*a*b*c)^2*(b*a)^2*c*b*a*b*c*a*(b*a*b*c)^2)^2*(b*a)^2*c*b*a*b*c, (a*(b*c)^2*b)^12, a*b*(a*(b*a*b*c)^4)^2*(b*a)^2*(c*b*a*b)^4*a*(b*a*b*c)^4*b, (a*b)^5*a*c*(a*(b*a*b*c)^2*b*a*b)^3*a*c*(b*a)^6*(c*b*a*b)^3*c*b, 
  ((a*b)^2*a*(b*a*b*c)^4*a*b*a*(c*b*a*b)^3*c*b)^2, ((a*b)^4*c*b*a*b*c*b)^2*a*b*c*b*a*b*c*(a*b)^2*a*(c*b*a*b*c*b)^2*c*b*a*b*c*(a*b)^2*a*(c*b*a*b)^3*c*b, (a*b)^5*a*(c*b*a*b)^3*c*b*((c*b*a*b)^3*c*b*a)^2*(b*a)^4*(c*b*a*b)^3*c, 
  a*b*a*c*b*a*(b*c)^2*b*a*b*c*(b*c*b*a*b*c*a)^2*(b*c)^2*b*a*(b*c)^2*a*b*a*(c*b*a*b*c*b)^4*a*b*a*(c*b)^2*a*(b*c)^2*b, (a*b*c*(a*b*c*b)^2*a*(c*b*a*b*c*b)^2*c*b)^3, 
  (a*b)^2*a*(b*a*b*c)^4*a*b*a*(c*b)^2*a*(b*c)^2*a*b*a*(c*b*a*b)^4*(a*b)^2*a*(c*b*a*(b*c)^2*b)^2*c*b*a*b*c, (a*b)^4*a*(b*a*b*c)^4*(a*b)^2*((a*b)^2*a*c)^2*b*a*b*c*(a*(b*a*b*c)^2*b*a*b)^2*a*(b*a*b*c)^2*a*c, 
  (a*b*a*(b*a*b*c)^2*(b*a)^3*c*b*a*b*c*b*(c*b*a)^2*b*c*a*(b*c)^2*b*a*b*c)^2, a*(b*a*b*c)^4*a*c*b*a*b*c*b*(a*c*b*a*(b*c)^2*b*a*b*c)^2*(b*c*b*a*b*c)^2*b*a*c*b*a*(b*c)^2*b*(a*b*c)^2*b*a*b*c, 
  (a*b*a*(b*a*b*c)^2*(b*a)^3*c*b*a*b*c*a*(b*a*b*c)^2*(b*a)^2*c*b*a*b*c)^2, (a*b*a*(b*a*b*a*(b*a*b*c)^2)^3*b)^2, a*b*c*a*(b*c*b*a*(b*c)^2)^2*b*c*b*a*b*c*b*(a*(c*b*a*b*c*b)^2*c*b*a*b*c*a*c)^2*a*(c*b*a*b*c*b)^2*c*b, 
  (a*b)^5*a*(c*b*a*b)^4*a*((c*b*a*b)^2*a*b*a*b)^2*((c*b*a*b)^2*a)^2*(c*b*a*b)^3*c*b, (a*b)^2*a*(b*a*b*c)^4*(a*b)^2*a*(c*b*a*(b*c)^2*b)^2*c*b*a*b*c*(a*b)^2*a*(c*b*a*b)^4*a*b*a*(b*a*(b*c)^2)^2*b, (a*b*c*a*(c*b*a*b)^2*c*b)^6, (a*b*a*b*a*(b*a*b*c)^4)^4, 
  ((a*b)^5*a*(c*b*a*b)^3*c*(a*b)^4*a*c*(b*a)^3*b*c*b)^2, ((a*b)^4*a*(b*a*b*c)^4*(a*b)^4*a*(c*b*a*b)^2*c)^2, (a*b)^2*a*(b*a*b*c)^4*a*b*a*(c*b)^3*a*(b*c)^3*a*b*a*(c*b*a*b)^4*(a*b)^2*a*(c*b*a*(b*c)^3*b)^2*c*b*a*b*c, 
  a*b*a*(b*a*b*c)^4*(a*b)^2*a*c*b*a*b*c*b*a*((c*b)^2*a*b*c*b)^3*c*a*b*a*c*(b*c*b*a)^2*(c*b*a*b*c*b)^2*c*b*a*b*c*a*c*b, ((a*b*a*(b*a*b*c)^2*b)^2*(a*b)^2*c*(b*a*b*c*b*a)^2*b*c*b)^2, (a*b)^3*a*(b*a*(c*b*a*b)^3*c)^3*(b*a)^4*((c*b*a*b)^3*c*b)^2, 
  (a*b*c*a*(b*c*b*a*b*c)^2*(a*(c*b*a*b*c*b)^2)^2*c*b)^2, a*((b*a)^3*b*(a*(c*b*a*b)^3*c)^2)^2*a*(b*a*b*c)^4, (a*b)^5*c*b*a*b*(c*b*a)^2*(b*c)^2*b*a*b*c*(a*b*c*b)^2*(a*b)^2*a*(b*a*c*b*a*b*c)^2*(b*c*b*a*b*c*a)^2*(b*a)^2*(b*a*b*c)^4*b, 
  (a*b)^4*a*(b*a*c*b*a*b*c)^2*b*c*b*a*b*c*((a*b*c*b)^2*a*b)^2*c*b*a*b*c*(a*b)^4*c*b*a*b*((c*b*a*b)^2*c*b*a)^2*b*c, (a*b)^3*a*(c*b*a*b)^2*(c*b*a*b*c*b*a)^2*c*b*a*b*c*(b*c*b*a*b*c*a)^2*(c*b*a*b)^3*c*a*(b*a*b*c)^2*b*a*c*b*a*(b*c)^2*b*(a*b*c)^2*b*a*b*c, 
  a*b*a*((c*b)^2*a*b*c*b)^3*c*a*(c*b*a*b*c*b)^3*(a*b*c*b)^2*c*a*(c*b*a*b*c*b)^2*c*b*a*b*c*(a*b*c*b)^2*(c*b)^2*a*b*c*b, (a*b*a*(b*a*b*c)^2*b)^2*(a*(b*c*b*a*b*c)^3)^2*b*a*(c*b*a*b*c*b)^3*(a*b*c*b)^2, 
  (a*b)^4*a*c*a*(c*b*a*b*c*b)^2*c*b*a*b*c*a*c*(a*b)^4*a*(c*b*a*b)^3*c*(a*b)^4*a*(c*b)^2*a*(b*c)^2*(a*b)^4*a*(c*b*a*b)^3*c, (a*b*a*(b*a*b*c)^2*(a*b)^2*a*((c*b*a*b)^2*a*b*a*b)^2*c*b*a*b*c*b)^2, 
  (a*b)^3*a*(b*c*b*a*b*c)^2*(b*c*b*a*b*c*a)^2*(b*a)^2*(b*c*b*a*b*c)^4*(b*a)^2*(b*a*c*b*a*b*c)^2*(b*c*b*a*b*c)^2*b, ((a*b)^4*a*c*b*a*b*c)^2*(b*a*b*c)^2*(b*a)^4*((c*b*a*b)^2*a*b*a*b)^2*c*b*a*b*c*(a*b)^2*a*(b*a*b*c)^4, (((a*b)^3*a*(b*a*b*c)^4)^2*b)^2, 
  (a*b)^3*a*(b*a*b*c)^4*a*(b*a*b*c)^2*b*a*c*b*a*(b*c)^2*b*a*b*c*(a*b*c*b)^4*c*b*a*b*c*(b*c*b*a*b*c*a)^2*(c*b*a*b)^3*c*b, a*b*a*c*b*a*b*c*b*a*(c*b)^2*a*(b*c)^3*b*a*b*c*a*((b*c)^2*b*a*b*c)^4*a*c*b*a*(b*c)^3*b*a*(b*c)^2*a*b*c*b*a*b*c*a*(c*b*a*b)^3*c*b, 
  (a*b)^2*(a*b*a*(c*b*a*b)^3*c)^2*(b*a*b*c)^2*b*a*c*b*a*(b*c)^2*b*a*b*c*(a*b*c*b)^5*a*b*c*a*b*a*(c*b*a*b)^3*c, ((a*b*a*(b*a*b*c)^2*b)^2*a*(b*a*(b*c)^2)^2*b*a*(b*a*b*c)^2*b)^2, (a*(b*c)^3*b)^12, 
  (a*b)^3*a*((b*c)^3*b*a*b*c)^4*(a*(b*c)^3*b)^4*(a*b)^2*a*(c*b*a*b)^3*c*b, (a*b*c*a*(b*c*b*a*b*c)^5*b*a*(c*b*a*b*c*b)^2*c*b)^2, (a*b*c*(a*(b*c)^2*b)^2*a*(c*b*a*(b*c)^2*b)^2*c*b)^3, 
  a*b*a*(b*a*b*c)^2*(b*a)^2*b*(a*c*b*a*(b*c)^2*b*a*b*c)^2*b*(c*b*a*b*c*(a*b)^2*a)^2*(b*c*b*a*b*c)^5*b*a*c*b*a*(b*c)^2*b*a*b*c, (a*b)^4*c*b*a*b*c*a*b*a*(c*b*a*b*c*a*b*a*(c*b*a*b)^2*a*b*a*(b*a*b*c)^2*b*a*b)^2*a*b*a*(b*a*b*c)^2*a*b*a*(c*b*a*b)^3*c*b, 
  ((a*b)^5*((c*b*a*b)^3*c*a)^2*(c*b*a*b)^3*c*b)^2, (a*b)^4*c*b*a*(c*b*a*b*c*b)^5*(c*b)^2*a*b*c*((b*c)^2*b*a*b*c*a)^2*b*c*a*b*a*(b*a*b*c)^4*(a*b*a*c)^2*(b*a*b*c)^3*b, 
  (a*b)^4*c*a*b*a*(c*b*a*b)^4*a*b*a*(c*b)^2*a*b*c*b*(c*b*a)^2*(b*c)^3*b*a*b*c*(a*(b*c)^2*b)^5*(a*b*c)^2*a*b*a*(c*b*a*b)^3*c*b, (a*b*c)^2*b*a*b*c*(a*(b*c)^2*b)^4*c*b*a*b*c*b*a*(c*b*a*b*c*b)^3*a*(b*c*b*a*(b*c)^2)^4*a*(b*c*b*a*b*c)^2*b*c*b, 
  (a*b*c*a*c*(b*c*b*a)^2*(c*b*a*b*c*b)^2*c*b)^4, (a*b*a*(b*a*b*c)^2)^10, (a*b)^5*(a*(c*b*a*b)^3*c)^2*a*(c*b*a*b)^2*a*((c*b*a*b*c*b)^2*c*b*a*b*c*a*b)^2*a*(c*b*a*b)^4*a*b*a*(b*a*b*c)^2, (a*(b*c)^4*b)^12, (a*b*c*a*c*b)^24, 
  (a*b)^4*a*(c*b*a*b)^3*c*(a*b)^4*a*((c*b)^3*a*b)^2*c*((b*c)^2*b*a*b*c*a)^2*(b*a)^2*(b*a*b*c)^4*a*b*a*(c*b*a*b)^2*a*b*a*(b*a*b*c)^4*a*b*a*((c*b)^2*a*b*c*b)^3*c*b*c, ((a*b)^2*(a*c)^2)^24, ((a*b)^2*a*c)^120, ((a*b)^3*c*b)^105, 
  ((a*b)^4*a*(b*a*c*b*a*b*c)^2*b)^210, (a*(b*c)^2*b*a*c*b)^616, (a*b*a*b*(a*(b*a*b*c)^2)^2)^280 ];

H := F/rels;

a := SparseRep(ClassTransposition(1,2,4,6));
b := SparseRep(ClassTransposition(1,3,2,6));
c := SparseRep(ClassTransposition(2,3,4,6));
G_C := Group(a,b,c);

phi := GroupHomomorphismByImagesNC(H,G_C);

return phi;

#############################################################################
##
#E  epifromfpgrouptocollatzgroup_c.g . . . . . . . . . . . . . . .  ends here
