/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.listeners;

import freemind.controller.NodeMouseMotionListener;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CommonNodeMouseMotionListener
implements NodeMouseMotionListener.NodeMouseMotionObserver {
    private final ModeController c;
    private static Logger logger;
    private static Tools.IntHolder timeForDelayedSelection;
    private static Tools.BooleanHolder delayedSelectionEnabled;
    private Timer timerForDelayedSelection;
    private Rectangle controlRegionForDelayedSelection;
    private MouseEvent mMousePressedEvent;

    @Override
    public void updateSelectionMethod() {
        if (timeForDelayedSelection == null) {
            timeForDelayedSelection = new Tools.IntHolder();
        }
        delayedSelectionEnabled = new Tools.BooleanHolder();
        delayedSelectionEnabled.setValue(!this.c.getFrame().getProperty("selection_method").equals("selection_method_direct"));
        if (this.c.getFrame().getProperty("selection_method").equals("selection_method_by_click")) {
            timeForDelayedSelection.setValue(Integer.MAX_VALUE);
        } else {
            timeForDelayedSelection.setValue(Integer.parseInt(this.c.getFrame().getProperty("time_for_delayed_selection")));
        }
    }

    public CommonNodeMouseMotionListener(ModeController controller) {
        this.c = controller;
        if (logger == null) {
            logger = this.c.getFrame().getLogger(this.getClass().getName());
        }
        if (delayedSelectionEnabled == null) {
            this.updateSelectionMethod();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        logger.finest("Event: mouseMoved");
        MainView node = (MainView)e.getComponent();
        boolean isLink = node.updateCursor(e.getX());
        if (isLink) {
            this.c.getFrame().out(this.c.getLinkShortText(node.getNodeView().getModel()));
        }
        if (this.controlRegionForDelayedSelection != null && delayedSelectionEnabled.getValue() && !this.controlRegionForDelayedSelection.contains(e.getPoint())) {
            this.createTimer(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        logger.fine("Event: mouseDragged");
        this.stopTimerForDelayedSelection();
        NodeView nodeV = ((MainView)e.getComponent()).getNodeView();
        if (!this.c.getView().isSelected(nodeV)) {
            this.c.extendSelection(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        logger.finest("Event: mouseEntered");
        if (!JOptionPane.getFrameForComponent(e.getComponent()).isFocused()) {
            return;
        }
        this.createTimer(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        logger.fine("Event: mousePressed");
        this.mMousePressedEvent = e;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        logger.finest("Event: mouseExited");
        this.stopTimerForDelayedSelection();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        logger.fine("Event: mouseReleased");
        MouseEvent ev = e;
        if (Tools.isLinux() || Tools.isMacOsX()) {
            ev = this.mMousePressedEvent;
        }
        this.handlePopupMenu(ev);
        if (ev.isConsumed()) {
            return;
        }
        if (e.getModifiers() == 16) {
            this.c.plainClick(e);
            e.consume();
        }
    }

    protected void handlePopupMenu(MouseEvent e) {
        this.stopTimerForDelayedSelection();
        logger.fine("Extending selection for " + e);
        this.c.extendSelection(e);
        logger.fine("Looking for popup for " + e);
        this.c.showPopupMenu(e);
    }

    protected Rectangle getControlRegion(Point2D p) {
        int side = 8;
        return new Rectangle((int)(p.getX() - (double)(side / 2)), (int)(p.getY() - (double)(side / 2)), side, side);
    }

    public void createTimer(MouseEvent e) {
        this.stopTimerForDelayedSelection();
        this.controlRegionForDelayedSelection = this.getControlRegion(e.getPoint());
        this.timerForDelayedSelection = new Timer();
        this.timerForDelayedSelection.schedule((TimerTask)new timeDelayedSelection(this.c, e), delayedSelectionEnabled.getValue() ? (long)timeForDelayedSelection.getValue() : 0L);
    }

    protected void stopTimerForDelayedSelection() {
        if (this.timerForDelayedSelection != null) {
            this.timerForDelayedSelection.cancel();
        }
        this.timerForDelayedSelection = null;
        this.controlRegionForDelayedSelection = null;
    }

    protected class timeDelayedSelection
    extends TimerTask {
        private final ModeController c;
        private final MouseEvent e;

        timeDelayedSelection(ModeController c, MouseEvent e) {
            this.c = c;
            this.e = e;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (timeDelayedSelection.this.e.getModifiers() == 0 && !timeDelayedSelection.this.c.isBlocked() && timeDelayedSelection.this.c.getView().getSelecteds().size() <= 1) {
                        timeDelayedSelection.this.c.extendSelection(timeDelayedSelection.this.e);
                    }
                }
            });
        }
    }
}

