%% Generated by the Erlang ASN.1 BER compiler. Version: 5.0.8
%% Purpose: Encoding and decoding of the types in PKCS-FRAME.

-module('PKCS-FRAME').
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-include("PKCS-FRAME.hrl").
-asn1_info([{vsn,'5.0.8'},
            {module,'PKCS-FRAME'},
            {options,[warnings,ber,errors,
 {cwd,"/build/erlang/src/otp/lib/public_key/asn1"},
 {outdir,"/build/erlang/src/otp/lib/public_key/asn1"},
 asn1config,noobj,der,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
'enc_RC5-CBC-Parameters'/2,
'enc_RC2-CBC-Parameter'/2,
'enc_PBMAC1-params'/2,
'enc_PBES2-params'/2,
enc_PBEParameter/2,
'enc_PBKDF2-params'/2,
enc_AttributeUsage/2,
enc_Context/2,
enc_EncryptedData/2,
enc_EncryptedPrivateKeyInfo/2,
enc_Attributes/2,
enc_PrivateKey/2,
enc_Version/2,
enc_PrivateKeyInfo/2
]).

-export([
'dec_RC5-CBC-Parameters'/2,
'dec_RC2-CBC-Parameter'/2,
'dec_PBMAC1-params'/2,
'dec_PBES2-params'/2,
dec_PBEParameter/2,
'dec_PBKDF2-params'/2,
dec_AttributeUsage/2,
dec_Context/2,
dec_EncryptedData/2,
dec_EncryptedPrivateKeyInfo/2,
dec_Attributes/2,
dec_PrivateKey/2,
dec_Version/2,
dec_PrivateKeyInfo/2
]).

-export([
getenc_SupportingAlgorithms/1,
'getenc_PBMAC1-MACs'/1,
'getenc_PBMAC1-KDFs'/1,
getenc_PBMAC1Algorithms/1,
'getenc_PBES2-Encs'/1,
'getenc_PBES2-KDFs'/1,
getenc_PBES2Algorithms/1,
getenc_PBES1Algorithms/1,
'getenc_PBKDF2-PRFs'/1,
'getenc_PBKDF2-SaltSources'/1,
getenc_SupportedContexts/1,
getenc_KeyEncryptionAlgorithms/1,
getenc_PrivateKeyAlgorithms/1,
getenc_internal_object_set_argument_9/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_1/1
]).

-export([
getdec_SupportingAlgorithms/1,
'getdec_PBMAC1-MACs'/1,
'getdec_PBMAC1-KDFs'/1,
getdec_PBMAC1Algorithms/1,
'getdec_PBES2-Encs'/1,
'getdec_PBES2-KDFs'/1,
getdec_PBES2Algorithms/1,
getdec_PBES1Algorithms/1,
'getdec_PBKDF2-PRFs'/1,
'getdec_PBKDF2-SaltSources'/1,
getdec_SupportedContexts/1,
getdec_KeyEncryptionAlgorithms/1,
getdec_PrivateKeyAlgorithms/1,
getdec_internal_object_set_argument_9/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_1/1
]).

-export([
'rc5-CBC-PAD'/0,
rc2CBC/0,
'des-EDE3-CBC'/0,
desCBC/0,
'id-hmacWithSHA1'/0,
encryptionAlgorithm/0,
digestAlgorithm/0,
'id-PBMAC1'/0,
'id-PBES2'/0,
'pbeWithSHA1AndRC2-CBC'/0,
'pbeWithSHA1AndDES-CBC'/0,
'pbeWithMD5AndRC2-CBC'/0,
'pbeWithMD5AndDES-CBC'/0,
'pbeWithMD2AndRC2-CBC'/0,
'pbeWithMD2AndDES-CBC'/0,
'id-PBKDF2'/0,
'pkcs-5'/0,
pkcs/0,
rsadsi/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('RC5-CBC-Parameters', Data) -> 'enc_RC5-CBC-Parameters'(Data);
encode_disp('RC2-CBC-Parameter', Data) -> 'enc_RC2-CBC-Parameter'(Data);
encode_disp('PBMAC1-params', Data) -> 'enc_PBMAC1-params'(Data);
encode_disp('PBES2-params', Data) -> 'enc_PBES2-params'(Data);
encode_disp('PBEParameter', Data) -> enc_PBEParameter(Data);
encode_disp('PBKDF2-params', Data) -> 'enc_PBKDF2-params'(Data);
encode_disp('AttributeUsage', Data) -> enc_AttributeUsage(Data);
encode_disp('Context', Data) -> enc_Context(Data);
encode_disp('EncryptedData', Data) -> enc_EncryptedData(Data);
encode_disp('EncryptedPrivateKeyInfo', Data) -> enc_EncryptedPrivateKeyInfo(Data);
encode_disp('Attributes', Data) -> enc_Attributes(Data);
encode_disp('PrivateKey', Data) -> enc_PrivateKey(Data);
encode_disp('Version', Data) -> enc_Version(Data);
encode_disp('PrivateKeyInfo', Data) -> enc_PrivateKeyInfo(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('RC5-CBC-Parameters', Data) -> 'dec_RC5-CBC-Parameters'(Data);
decode_disp('RC2-CBC-Parameter', Data) -> 'dec_RC2-CBC-Parameter'(Data);
decode_disp('PBMAC1-params', Data) -> 'dec_PBMAC1-params'(Data);
decode_disp('PBES2-params', Data) -> 'dec_PBES2-params'(Data);
decode_disp('PBEParameter', Data) -> dec_PBEParameter(Data);
decode_disp('PBKDF2-params', Data) -> 'dec_PBKDF2-params'(Data);
decode_disp('AttributeUsage', Data) -> dec_AttributeUsage(Data);
decode_disp('Context', Data) -> dec_Context(Data);
decode_disp('EncryptedData', Data) -> dec_EncryptedData(Data);
decode_disp('EncryptedPrivateKeyInfo', Data) -> dec_EncryptedPrivateKeyInfo(Data);
decode_disp('Attributes', Data) -> dec_Attributes(Data);
decode_disp('PrivateKey', Data) -> dec_PrivateKey(Data);
decode_disp('Version', Data) -> dec_Version(Data);
decode_disp('PrivateKeyInfo', Data) -> dec_PrivateKeyInfo(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  RC5-CBC-Parameters
%%================================
'enc_RC5-CBC-Parameters'(Val) ->
    'enc_RC5-CBC-Parameters'(Val, [<<48>>]).

'enc_RC5-CBC-Parameters'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{'v1-0',16}], [<<2>>]),

%%-------------------------------------------------
%% attribute rounds(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute blockSizeInBits(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute iv(4) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<4>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RC5-CBC-Parameters'(Tlv) ->
   'dec_RC5-CBC-Parameters'(Tlv, [16]).

'dec_RC5-CBC-Parameters'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{'v1-0',16}])
end
,

%%-------------------------------------------------
%% attribute rounds(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_integer(V2, [2]),
if 8 =< Val2, Val2 =< 127 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute blockSizeInBits(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
Val3 = decode_integer(V3, [2]),
if 64 =< Val3, Val3 =< 128 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute iv(4) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{4,V4}|TempTlv5] ->
    {decode_octet_string(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'RC5-CBC-Parameters',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  RC2-CBC-Parameter
%%================================
'enc_RC2-CBC-Parameter'(Val) ->
    'enc_RC2-CBC-Parameter'(Val, [<<48>>]).

'enc_RC2-CBC-Parameter'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute rc2ParameterVersion(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute iv(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RC2-CBC-Parameter'(Tlv) ->
   'dec_RC2-CBC-Parameter'(Tlv, [16]).

'dec_RC2-CBC-Parameter'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute rc2ParameterVersion(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {decode_integer(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute iv(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val1 = decode_octet_string(V2, [4]),
C1 = byte_size(Val1),
if C1 =:= 8 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RC2-CBC-Parameter',Term1,Term2},
Res1.


%%================================
%%  PBMAC1-params
%%================================
'enc_PBMAC1-params'(Val) ->
    'enc_PBMAC1-params'(Val, [<<48>>]).

'enc_PBMAC1-params'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute keyDerivationFunc(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PBMAC1-params_keyDerivationFunc'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute messageAuthScheme(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PBMAC1-params_messageAuthScheme'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBMAC1-params_keyDerivationFunc
%%================================
'enc_PBMAC1-params_keyDerivationFunc'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_1'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBMAC1-params_messageAuthScheme
%%================================
'enc_PBMAC1-params_messageAuthScheme'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PBMAC1-params'(Tlv) ->
   'dec_PBMAC1-params'(Tlv, [16]).

'dec_PBMAC1-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keyDerivationFunc(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PBMAC1-params_keyDerivationFunc'(V1, [16]),

%%-------------------------------------------------
%% attribute messageAuthScheme(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PBMAC1-params_messageAuthScheme'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBMAC1-params',Term1,Term2},
Res1.
'dec_PBMAC1-params_keyDerivationFunc'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_1'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBMAC1-params_keyDerivationFunc',Term1,Term2},
Res1.
'dec_PBMAC1-params_messageAuthScheme'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBMAC1-params_messageAuthScheme',Term1,Term2},
Res1.


%%================================
%%  PBES2-params
%%================================
'enc_PBES2-params'(Val) ->
    'enc_PBES2-params'(Val, [<<48>>]).

'enc_PBES2-params'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute keyDerivationFunc(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PBES2-params_keyDerivationFunc'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptionScheme(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PBES2-params_encryptionScheme'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBES2-params_keyDerivationFunc
%%================================
'enc_PBES2-params_keyDerivationFunc'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_3'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBES2-params_encryptionScheme
%%================================
'enc_PBES2-params_encryptionScheme'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PBES2-params'(Tlv) ->
   'dec_PBES2-params'(Tlv, [16]).

'dec_PBES2-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keyDerivationFunc(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PBES2-params_keyDerivationFunc'(V1, [16]),

%%-------------------------------------------------
%% attribute encryptionScheme(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PBES2-params_encryptionScheme'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBES2-params',Term1,Term2},
Res1.
'dec_PBES2-params_keyDerivationFunc'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_3'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBES2-params_keyDerivationFunc',Term1,Term2},
Res1.
'dec_PBES2-params_encryptionScheme'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBES2-params_encryptionScheme',Term1,Term2},
Res1.


%%================================
%%  PBEParameter
%%================================
enc_PBEParameter(Val) ->
    enc_PBEParameter(Val, [<<48>>]).

enc_PBEParameter(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute salt(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute iterationCount(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PBEParameter(Tlv) ->
   dec_PBEParameter(Tlv, [16]).

dec_PBEParameter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute salt(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_octet_string(V1, [4]),
C1 = byte_size(Val1),
if C1 =:= 8 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute iterationCount(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBEParameter',Term1,Term2},
Res1.


%%================================
%%  PBKDF2-params
%%================================
'enc_PBKDF2-params'(Val) ->
    'enc_PBKDF2-params'(Val, [<<48>>]).

'enc_PBKDF2-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute salt(1) with type CHOICE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PBKDF2-params_salt'(Cindex1, []),

%%-------------------------------------------------
%% attribute iterationCount(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute keyLength(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute prf(4) with type SEQUENCE DEFAULT = {'PBKDF2-params_prf',{1,2,840,113549,2,7},'NULL'}
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case is_default_1(Cindex4) of
true -> {[],0};
false ->
'enc_PBKDF2-params_prf'(Cindex4, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBKDF2-params_salt
%%================================
'enc_PBKDF2-params_salt'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      specified ->
         encode_restricted_string(element(2,Val), [<<4>>]);
      otherSource ->
         'enc_PBKDF2-params_salt_otherSource'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  PBKDF2-params_salt_otherSource
%%================================
'enc_PBKDF2-params_salt_otherSource'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_5'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBKDF2-params_prf
%%================================
'enc_PBKDF2-params_prf'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_6'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PBKDF2-params'(Tlv) ->
   'dec_PBKDF2-params'(Tlv, [16]).

'dec_PBKDF2-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute salt(1) with type CHOICE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PBKDF2-params_salt'(V1, []),

%%-------------------------------------------------
%% attribute iterationCount(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val1 = decode_integer(V2, [2]),
if 1 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute keyLength(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{2,V3}|TempTlv4] ->
    {begin
Val2 = decode_integer(V3, []),
if 1 =< Val2, Val2 =< 'MAX' ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute prf(4) with type SEQUENCE DEFAULT = {'PBKDF2-params_prf',{1,2,840,113549,2,7},'NULL'}
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{16,V4}|TempTlv5] ->
    {'dec_PBKDF2-params_prf'(V4, []), TempTlv5};
    _ ->
        {{'PBKDF2-params_prf',{1,2,840,113549,2,7},'NULL'},Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PBKDF2-params',Term1,Term2,Term3,Term4},
Res1.
'dec_PBKDF2-params_salt'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'specified'
    {4, V1} -> 
        {specified, decode_octet_string(V1, [])};


%% 'otherSource'
    {16, V1} -> 
        {otherSource, 'dec_PBKDF2-params_salt_otherSource'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_PBKDF2-params_salt_otherSource'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_5'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBKDF2-params_salt_otherSource',Term1,Term2},
Res1.
'dec_PBKDF2-params_prf'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_6'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBKDF2-params_prf',Term1,Term2},
Res1.


%%================================
%%  AttributeUsage
%%================================
enc_AttributeUsage(Val) ->
    enc_AttributeUsage(Val, [<<10>>]).

enc_AttributeUsage(Val, TagIn) ->
case Val of
userApplications -> encode_tags(TagIn, [0], 1);
directoryOperation -> encode_tags(TagIn, [1], 1);
distributedOperation -> encode_tags(TagIn, [2], 1);
dSAOperation -> encode_tags(TagIn, [3], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


dec_AttributeUsage(Tlv) ->
   dec_AttributeUsage(Tlv, [10]).

dec_AttributeUsage(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> userApplications;
1 -> directoryOperation;
2 -> distributedOperation;
3 -> dSAOperation;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end.



%%================================
%%  Context
%%================================
enc_Context(Val) ->
    enc_Context(Val, [<<48>>]).

enc_Context(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,
ObjcontextType = 
   'PKCS-FRAME':'getenc_SupportedContexts'(                                   Cindex1),

%%-------------------------------------------------
%% attribute contextType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute contextValues(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Context_contextValues'(Cindex2, [<<49>>], ObjcontextType),

%%-------------------------------------------------
%% attribute fallback(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_2(Cindex3) of
true -> {[],0};
false ->
encode_boolean(Cindex3, [<<1>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Context_contextValues
%%================================
enc_Context_contextValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_Context_contextValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Context_contextValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Context_contextValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_Context_contextValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_Context(Tlv) ->
   dec_Context(Tlv, [16]).

dec_Context(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute contextType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'PKCS-FRAME':'getdec_SupportedContexts'(Term1),

%%-------------------------------------------------
%% attribute contextValues(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Context_contextValues'(V2, [17], ObjFun),

%%-------------------------------------------------
%% attribute fallback(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{1,V3}|TempTlv4] ->
    {decode_boolean(V3, []), TempTlv4};
    _ ->
        {false,Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Context',Term1,Term2,Term3},
Res1.
'dec_Context_contextValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  EncryptedData
%%================================
enc_EncryptedData(Val) ->
    enc_EncryptedData(Val, [<<4>>]).

enc_EncryptedData(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncryptedData(Tlv) ->
   dec_EncryptedData(Tlv, [4]).

dec_EncryptedData(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  EncryptedPrivateKeyInfo
%%================================
enc_EncryptedPrivateKeyInfo(Val) ->
    enc_EncryptedPrivateKeyInfo(Val, [<<48>>]).

enc_EncryptedPrivateKeyInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute encryptionAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_EncryptedPrivateKeyInfo_encryptionAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedData(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedPrivateKeyInfo_encryptionAlgorithm
%%================================
enc_EncryptedPrivateKeyInfo_encryptionAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_7'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EncryptedPrivateKeyInfo(Tlv) ->
   dec_EncryptedPrivateKeyInfo(Tlv, [16]).

dec_EncryptedPrivateKeyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute encryptionAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_EncryptedPrivateKeyInfo_encryptionAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute encryptedData(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedPrivateKeyInfo',Term1,Term2},
Res1.
'dec_EncryptedPrivateKeyInfo_encryptionAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_7'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedPrivateKeyInfo_encryptionAlgorithm',Term1,Term2},
Res1.


%%================================
%%  Attributes
%%================================
enc_Attributes(Val) ->
    enc_Attributes(Val, [<<49>>]).

enc_Attributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Attributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Attributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Attributes_PKAttribute'(H, [<<48>>]),
   'enc_Attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Attributes_PKAttribute
%%================================
enc_Attributes_PKAttribute(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,
Objtype = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_8'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Attributes_PKAttribute_values'(Cindex2, [<<49>>], Objtype),

%%-------------------------------------------------
%% attribute valuesWithContext(3) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Attributes_PKAttribute_valuesWithContext'(Cindex3, [<<49>>], Objtype)
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Attributes_PKAttribute_values
%%================================
enc_Attributes_PKAttribute_values(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_Attributes_PKAttribute_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Attributes_PKAttribute_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attributes_PKAttribute_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_Attributes_PKAttribute_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Attributes_PKAttribute_valuesWithContext
%%================================
enc_Attributes_PKAttribute_valuesWithContext(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_Attributes_PKAttribute_valuesWithContext_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Attributes_PKAttribute_valuesWithContext_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attributes_PKAttribute_valuesWithContext_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Attributes_PKAttribute_valuesWithContext_SETOF'(H, [<<48>>], ObjFun),
   'enc_Attributes_PKAttribute_valuesWithContext_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Attributes_PKAttribute_valuesWithContext_SETOF
%%================================
enc_Attributes_PKAttribute_valuesWithContext_SETOF(Val, TagIn, ObjFun) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute value(1) with type typefieldType
%%-------------------------------------------------
   {TmpBytes1,_} = ObjFun('Type', Cindex1, []),
   {EncBytes1,EncLen1} = encode_open_type(TmpBytes1, [])
,

%%-------------------------------------------------
%% attribute contextList(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Attributes_PKAttribute_valuesWithContext_SETOF_contextList'(Cindex2, [<<49>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Attributes_PKAttribute_valuesWithContext_SETOF_contextList
%%================================
enc_Attributes_PKAttribute_valuesWithContext_SETOF_contextList(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Attributes_PKAttribute_valuesWithContext_SETOF_contextList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Attributes_PKAttribute_valuesWithContext_SETOF_contextList_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attributes_PKAttribute_valuesWithContext_SETOF_contextList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Context'(H, [<<48>>]),
   'enc_Attributes_PKAttribute_valuesWithContext_SETOF_contextList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Attributes(Tlv) ->
   dec_Attributes(Tlv, [17]).

dec_Attributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Attributes_PKAttribute'(V1, [16]) || V1 <- Tlv1].


'dec_Attributes_PKAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'PKCS-FRAME':'getdec_internal_object_set_argument_8'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Attributes_PKAttribute_values'(V2, [17], ObjFun),

%%-------------------------------------------------
%% attribute valuesWithContext(3) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{17,V3}|TempTlv4] ->
    {'dec_Attributes_PKAttribute_valuesWithContext'(V3, [], ObjFun), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PKAttribute',Term1,Term2,Term3},
Res1.
'dec_Attributes_PKAttribute_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].


'dec_Attributes_PKAttribute_valuesWithContext'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Attributes_PKAttribute_valuesWithContext_SETOF'(V1, [16], ObjFun) || V1 <- Tlv1].


'dec_Attributes_PKAttribute_valuesWithContext_SETOF'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute value(1) with type typefieldType
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
,

%%-------------------------------------------------
%% attribute contextList(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Attributes_PKAttribute_valuesWithContext_SETOF_contextList'(V2, [17]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attributes_PKAttribute_valuesWithContext_SETOF',Term1,Term2},
Res1.
'dec_Attributes_PKAttribute_valuesWithContext_SETOF_contextList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Context'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PrivateKey
%%================================
enc_PrivateKey(Val) ->
    enc_PrivateKey(Val, [<<4>>]).

enc_PrivateKey(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_PrivateKey(Tlv) ->
   dec_PrivateKey(Tlv, [4]).

dec_PrivateKey(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  Version
%%================================
enc_Version(Val) ->
    enc_Version(Val, [<<2>>]).

enc_Version(Val, TagIn) ->
encode_integer(Val, [{v1,0}], TagIn).


dec_Version(Tlv) ->
   dec_Version(Tlv, [2]).

dec_Version(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v1,0}])
end
.



%%================================
%%  PrivateKeyInfo
%%================================
enc_PrivateKeyInfo(Val) ->
    enc_PrivateKeyInfo(Val, [<<48>>]).

enc_PrivateKeyInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v1,0}], [<<2>>]),

%%-------------------------------------------------
%% attribute privateKeyAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PrivateKeyInfo_privateKeyAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute privateKey(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute attributes(4)   External PKCS-FRAME:Attributes OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Attributes'(Cindex4, [<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PrivateKeyInfo_privateKeyAlgorithm
%%================================
enc_PrivateKeyInfo_privateKeyAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-FRAME':'getenc_internal_object_set_argument_9'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PrivateKeyInfo(Tlv) ->
   dec_PrivateKeyInfo(Tlv, [16]).

dec_PrivateKeyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0}])
end
,

%%-------------------------------------------------
%% attribute privateKeyAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PrivateKeyInfo_privateKeyAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute privateKey(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

%%-------------------------------------------------
%% attribute attributes(4)   External PKCS-FRAME:Attributes OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'dec_Attributes'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PrivateKeyInfo',Term1,Term2,Term3,Term4},
Res1.
'dec_PrivateKeyInfo_privateKeyAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-FRAME':'getdec_internal_object_set_argument_9'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PrivateKeyInfo_privateKeyAlgorithm',Term1,Term2},
Res1.
'rc5-CBC-PAD'() ->
{1,2,840,113549,3,9}.

rc2CBC() ->
{1,2,840,113549,3,2}.

'des-EDE3-CBC'() ->
{1,2,840,113549,3,7}.

desCBC() ->
{1,3,14,3,2,7}.

'id-hmacWithSHA1'() ->
{1,2,840,113549,2,7}.

encryptionAlgorithm() ->
{1,2,840,113549,3}.

digestAlgorithm() ->
{1,2,840,113549,2}.

'id-PBMAC1'() ->
{1,2,840,113549,1,5,14}.

'id-PBES2'() ->
{1,2,840,113549,1,5,13}.

'pbeWithSHA1AndRC2-CBC'() ->
{1,2,840,113549,1,5,11}.

'pbeWithSHA1AndDES-CBC'() ->
{1,2,840,113549,1,5,10}.

'pbeWithMD5AndRC2-CBC'() ->
{1,2,840,113549,1,5,6}.

'pbeWithMD5AndDES-CBC'() ->
{1,2,840,113549,1,5,3}.

'pbeWithMD2AndRC2-CBC'() ->
{1,2,840,113549,1,5,4}.

'pbeWithMD2AndDES-CBC'() ->
{1,2,840,113549,1,5,1}.

'id-PBKDF2'() ->
{1,2,840,113549,1,5,12}.

'pkcs-5'() ->
{1,2,840,113549,1,5}.

pkcs() ->
{1,2,840,113549,1}.

rsadsi() ->
{1,2,840,113549}.




%%================================
%%  SupportingAlgorithms
%%================================
getenc_SupportingAlgorithms({1,2,840,113549,2,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_SupportingAlgorithms({1,2,840,113549,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RC2-CBC-Parameter'(Val)
      end
   end;
getenc_SupportingAlgorithms({1,2,840,113549,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_restricted_string(Val, [<<4>>])
      end
   end;
getenc_SupportingAlgorithms({1,2,840,113549,3,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RC5-CBC-Parameters'(Val)
      end
   end;
getenc_SupportingAlgorithms({1,3,14,3,2,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_restricted_string(Val, [<<4>>])
      end
   end;
getenc_SupportingAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_SupportingAlgorithms'({1,2,840,113549,2,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_SupportingAlgorithms'({1,2,840,113549,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RC2-CBC-Parameter'(Bytes)
      end
   end;
'getdec_SupportingAlgorithms'({1,2,840,113549,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            begin
Val1 = decode_octet_string(Bytes, [4]),
C1 = byte_size(Val1),
if C1 =:= 8 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end
      end
   end;
'getdec_SupportingAlgorithms'({1,2,840,113549,3,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RC5-CBC-Parameters'(Bytes)
      end
   end;
'getdec_SupportingAlgorithms'({1,3,14,3,2,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            begin
Val2 = decode_octet_string(Bytes, [4]),
C2 = byte_size(Val2),
if C2 =:= 8 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end
      end
   end;
getdec_SupportingAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBMAC1-MACs
%%================================
'getenc_PBMAC1-MACs'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBMAC1-MACs'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBMAC1-KDFs
%%================================
'getenc_PBMAC1-KDFs'({1,2,840,113549,1,5,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBKDF2-params'(Val)
      end
   end;
'getenc_PBMAC1-KDFs'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBMAC1-KDFs'({1,2,840,113549,1,5,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBKDF2-params'(Bytes)
      end
   end;
'getdec_PBMAC1-KDFs'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBMAC1Algorithms
%%================================
getenc_PBMAC1Algorithms({1,2,840,113549,1,5,14}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBMAC1-params'(Val)
      end
   end;
getenc_PBMAC1Algorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBMAC1Algorithms'({1,2,840,113549,1,5,14}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBMAC1-params'(Bytes)
      end
   end;
getdec_PBMAC1Algorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBES2-Encs
%%================================
'getenc_PBES2-Encs'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBES2-Encs'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBES2-KDFs
%%================================
'getenc_PBES2-KDFs'({1,2,840,113549,1,5,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBKDF2-params'(Val)
      end
   end;
'getenc_PBES2-KDFs'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBES2-KDFs'({1,2,840,113549,1,5,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBKDF2-params'(Bytes)
      end
   end;
'getdec_PBES2-KDFs'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBES2Algorithms
%%================================
getenc_PBES2Algorithms({1,2,840,113549,1,5,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBES2-params'(Val)
      end
   end;
getenc_PBES2Algorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBES2Algorithms'({1,2,840,113549,1,5,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBES2-params'(Bytes)
      end
   end;
getdec_PBES2Algorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBES1Algorithms
%%================================
getenc_PBES1Algorithms({1,2,840,113549,1,5,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBEParameter'(Val)
      end
   end;
getenc_PBES1Algorithms({1,2,840,113549,1,5,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBEParameter'(Val)
      end
   end;
getenc_PBES1Algorithms({1,2,840,113549,1,5,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBEParameter'(Val)
      end
   end;
getenc_PBES1Algorithms({1,2,840,113549,1,5,6}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBEParameter'(Val)
      end
   end;
getenc_PBES1Algorithms({1,2,840,113549,1,5,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBEParameter'(Val)
      end
   end;
getenc_PBES1Algorithms({1,2,840,113549,1,5,11}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBEParameter'(Val)
      end
   end;
getenc_PBES1Algorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBES1Algorithms'({1,2,840,113549,1,5,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBEParameter'(Bytes)
      end
   end;
'getdec_PBES1Algorithms'({1,2,840,113549,1,5,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBEParameter'(Bytes)
      end
   end;
'getdec_PBES1Algorithms'({1,2,840,113549,1,5,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBEParameter'(Bytes)
      end
   end;
'getdec_PBES1Algorithms'({1,2,840,113549,1,5,6}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBEParameter'(Bytes)
      end
   end;
'getdec_PBES1Algorithms'({1,2,840,113549,1,5,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBEParameter'(Bytes)
      end
   end;
'getdec_PBES1Algorithms'({1,2,840,113549,1,5,11}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBEParameter'(Bytes)
      end
   end;
getdec_PBES1Algorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBKDF2-PRFs
%%================================
'getenc_PBKDF2-PRFs'({1,2,840,113549,2,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PBKDF2-PRFs'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBKDF2-PRFs'({1,2,840,113549,2,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PBKDF2-PRFs'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBKDF2-SaltSources
%%================================
'getenc_PBKDF2-SaltSources'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBKDF2-SaltSources'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedContexts
%%================================
getenc_SupportedContexts(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedContexts(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyEncryptionAlgorithms
%%================================
getenc_KeyEncryptionAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyEncryptionAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PrivateKeyAlgorithms
%%================================
getenc_PrivateKeyAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PrivateKeyAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_9
%%================================
getenc_internal_object_set_argument_9(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_9(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6({1,2,840,113549,2,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_6'({1,2,840,113549,2,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3({1,2,840,113549,1,5,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBKDF2-params'(Val)
      end
   end;
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_3'({1,2,840,113549,1,5,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBKDF2-params'(Bytes)
      end
   end;
getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_1
%%================================
getenc_internal_object_set_argument_1({1,2,840,113549,1,5,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_PBKDF2-params'(Val)
      end
   end;
getenc_internal_object_set_argument_1(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_1'({1,2,840,113549,1,5,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_PBKDF2-params'(Bytes)
      end
   end;
getdec_internal_object_set_argument_1(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try is_default_cs_3(Value) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= false ->
true;
is_default_2(_) ->
false.


is_default_cs_3(Value) ->
case Value of
{'PBKDF2-params_prf',
E1,
'NULL'} ->
check_objectidentifier(E1, {[[1,iso],[2,'member-body']],[840,113549,2,7]});
_ ->
throw(false)
end.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_objectidentifier(Value, {Prefix,Tail}) when is_tuple(Value) ->
    check_oid(tuple_to_list(Value), Prefix, Tail);
check_objectidentifier(_, _) ->
    throw(false).

check_oid([H|T], [K|Ks], Tail) ->
    case lists:member(H, K) of
        false ->
            throw(false);
        true ->
            check_oid(T, Ks, Tail)
    end;
check_oid(Tail, [], Tail) ->
    true;
check_oid(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_,L}|Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L)|Acc]);
collect_parts([{3,<<Unused,Bits/binary>>}|Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T,V}|Rest], Acc) ->
    collect_parts(Rest, [V|Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3,<<Unused,Bits/binary>>}|Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits|Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc|lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H|Al]).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error,{asn1,{decode_boolean,Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error,{asn1,{decode_null,Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal|ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1,Val2} =
        if
            AddedObjVal < 40 ->
                {0,AddedObjVal};
            AddedObjVal < 80 ->
                {1,AddedObjVal - 40};
            true ->
                {2,AddedObjVal - 80}
        end,
    list_to_tuple([Val1,Val2|ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv,_} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER',V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1,E2|Tail]) ->
    Head = 40 * E1 + E2,
    {H,Lh} = mk_object_val(Head),
    {R,Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H|R],Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B,L} = mk_object_val(H),
    {B,Len + L}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error,{asn1,{encode_boolean,X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes,length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_,NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error,{asn1,{encode_integer_namednumber,Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error,{asn1,{encode_integer,Val}}}).

encode_integer_neg(- 1, [B1|_T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255|Acc]).

encode_integer_pos(0, [B|_Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255|Acc]).

encode_length(L) when L =< 127 ->
    {[L],1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len|Oct],Len + 1};
        true ->
            exit({error,{asn1,too_long_length_oct,Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar,LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag|Trest], BytesSoFar, LenSoFar) ->
    {Bytes2,L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag,Bytes2|BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar,LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_|_] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T,V}, [T]) ->
    V;
match_tags({T,V}, [T|Tt]) ->
    match_tags(V, Tt);
match_tags([{T,V}], [T|Tt]) ->
    match_tags(V, Tt);
match_tags([{T,_V}|_] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag,_V} = Tlv, [T|_Tt]) ->
    exit({error,{asn1,{wrong_tag,{{expected,T},{got,Tag,Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255|Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack,Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128|Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val],1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal,_} ->
            NamedVal;
        _ ->
            Int
    end.
