/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class QuickSearchManager {
    private final Tree tree;
    private final Label label;
    private final QuickSearchState state;
    private final KeyListener listener;

    public QuickSearchManager(Tree tree, Label label) {
        this.tree = (Tree)Preconditions.checkNotNull((Object)tree);
        this.label = (Label)Preconditions.checkNotNull((Object)label);
        this.state = new QuickSearchState();
        this.listener = new TreeKeyListener();
        this.init();
    }

    private void init() {
        this.tree.addKeyListener(this.listener);
        this.reset(false);
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean resetTreeSelection) {
        this.state.reset();
        this.updateLabelText();
        if (resetTreeSelection) {
            this.updateTreeSelection(true);
        }
    }

    private void handleDownArrow(KeyEvent e) {
        if (this.isSearchActive()) {
            if (this.state.results.length > 0) {
                this.state.current++;
                this.state.current = this.state.current % this.state.results.length;
                this.updateTreeSelection(false);
            }
            e.doit = false;
        }
    }

    private void handleUpArrow(KeyEvent e) {
        if (this.isSearchActive()) {
            if (this.state.results.length > 0) {
                this.state.current--;
                if (this.state.current < 0) {
                    QuickSearchState quickSearchState = this.state;
                    quickSearchState.current = quickSearchState.current + this.state.results.length;
                }
                this.updateTreeSelection(false);
            }
            e.doit = false;
        }
    }

    private void handleBackspace(KeyEvent e) {
        if (this.isSearchActive()) {
            this.state.removeLastCharacterFromSearchText();
            if (this.isSearchActive()) {
                this.performSearch();
                this.updateLabelText();
                this.updateTreeSelection(true);
            } else {
                this.reset(false);
            }
            e.doit = false;
        }
    }

    private void handleMiscKeys(KeyEvent e) {
        if (Character.isLetterOrDigit(e.character)) {
            this.state.appendToSearchText(e);
            this.performSearch();
            this.updateLabelText();
            this.updateTreeSelection(true);
            e.doit = false;
        }
    }

    private boolean isSearchActive() {
        return !Strings.isNullOrEmpty((String)this.state.searchText);
    }

    private void performSearch() {
        final String searchText = this.state.searchText.toUpperCase();
        Predicate<TreeItem> predicate = new Predicate<TreeItem>(){

            public boolean apply(TreeItem item) {
                return item.getText().toUpperCase().contains(searchText);
            }
        };
        ImmutableList.Builder hits = ImmutableList.builder();
        this.filterRecursively((ImmutableList<TreeItem>)ImmutableList.copyOf((Object[])this.tree.getItems()), predicate, (ImmutableList.Builder<TreeItem>)hits);
        this.state.setResults((List)hits.build());
    }

    private void filterRecursively(ImmutableList<TreeItem> items, Predicate<TreeItem> predicate, ImmutableList.Builder<TreeItem> hits) {
        for (TreeItem item : items) {
            if (predicate.apply((Object)item)) {
                hits.add((Object)item);
            }
            if (!item.getExpanded()) continue;
            Object[] childItems = item.getItems();
            this.filterRecursively((ImmutableList<TreeItem>)ImmutableList.copyOf((Object[])childItems), predicate, hits);
        }
    }

    private void updateLabelText() {
        if (this.isSearchActive()) {
            this.label.setText(String.format("%s (%d matches)", this.state.searchText, this.state.results.length));
        } else {
            this.label.setText("Type to search, use arrows to navigate");
        }
    }

    private void updateTreeSelection(boolean clearIfNoResults) {
        if (this.state.results.length > 0) {
            TreeItem item = this.state.results[this.state.current];
            this.tree.setSelection(item);
            this.tree.notifyListeners(13, new Event());
        } else if (clearIfNoResults) {
            this.tree.setSelection(new TreeItem[0]);
            this.tree.notifyListeners(13, new Event());
        }
    }

    public void dispose() {
        if (!this.tree.isDisposed()) {
            this.tree.removeKeyListener(this.listener);
        }
    }

    private final class QuickSearchState {
        private String searchText;
        private TreeItem[] results;
        private int current;

        private QuickSearchState() {
            this.reset();
        }

        private void reset() {
            this.searchText = "";
            this.results = new TreeItem[0];
            this.current = -1;
        }

        private void appendToSearchText(KeyEvent e) {
            this.searchText = this.searchText + e.character;
        }

        private void removeLastCharacterFromSearchText() {
            String searchText = this.searchText;
            if (searchText.length() > 0) {
                this.searchText = searchText.substring(0, searchText.length() - 1);
            }
        }

        private void setResults(List<TreeItem> hits) {
            this.results = (TreeItem[])Iterables.toArray(hits, TreeItem.class);
            this.current = this.results.length > 0 ? 0 : -1;
        }
    }

    private final class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    QuickSearchManager.this.reset(false);
                    break;
                }
                case 27: {
                    QuickSearchManager.this.reset(true);
                    break;
                }
                case 0x1000002: {
                    QuickSearchManager.this.handleDownArrow(e);
                    break;
                }
                case 0x1000001: {
                    QuickSearchManager.this.handleUpArrow(e);
                    break;
                }
                case 8: {
                    QuickSearchManager.this.handleBackspace(e);
                    break;
                }
                default: {
                    QuickSearchManager.this.handleMiscKeys(e);
                }
            }
        }
    }
}

