/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.ResolverConfigurationComponent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractMavenWizardPage
extends WizardPage {
    protected static final int MAX_HISTORY = 15;
    private ProjectImportConfiguration importConfiguration;
    protected ResolverConfigurationComponent resolverConfigurationComponent;
    protected IDialogSettings dialogSettings;
    private Map<String, List<Combo>> fieldsWithHistory;
    private boolean isHistoryLoaded = false;

    protected AbstractMavenWizardPage(String pageName) {
        this(pageName, null);
    }

    protected AbstractMavenWizardPage(String pageName, ProjectImportConfiguration importConfiguration) {
        super(pageName);
        this.importConfiguration = importConfiguration;
        this.fieldsWithHistory = new HashMap<String, List<Combo>>();
        this.initDialogSettings();
    }

    public ProjectImportConfiguration getImportConfiguration() {
        return this.importConfiguration;
    }

    protected void createAdvancedSettings(Composite composite, GridData gridData) {
        if (this.importConfiguration != null) {
            gridData.verticalIndent = 7;
            this.resolverConfigurationComponent = new ResolverConfigurationComponent(composite, this.importConfiguration, true);
            this.resolverConfigurationComponent.setLayoutData(gridData);
            this.addFieldWithHistory("projectNameTemplate", this.resolverConfigurationComponent.template);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (!this.isHistoryLoaded) {
                if (this.resolverConfigurationComponent != null) {
                    this.resolverConfigurationComponent.loadData();
                }
                this.loadInputHistory();
                this.isHistoryLoaded = true;
            } else {
                this.saveInputHistory();
            }
            if (this.resolverConfigurationComponent != null) {
                this.resolverConfigurationComponent.loadData();
            }
        }
        super.setVisible(visible);
    }

    public void dispose() {
        this.saveInputHistory();
        super.dispose();
    }

    private void initDialogSettings() {
        Object pluginSettings = MavenPluginActivator.getDefault() == null ? new DialogSettings("Workbench") : M2EUIPluginActivator.getDefault().getDialogSettings();
        this.dialogSettings = pluginSettings.getSection(this.getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = pluginSettings.addNewSection(this.getName());
            pluginSettings.addSection(this.dialogSettings);
        }
    }

    private void loadInputHistory() {
        for (Map.Entry<String, List<Combo>> e : this.fieldsWithHistory.entrySet()) {
            String id = e.getKey();
            String[] items = this.dialogSettings.getArray(id);
            if (items == null) continue;
            for (Combo combo : e.getValue()) {
                String text = combo.getText();
                combo.setItems(items);
                if (text.length() <= 0) continue;
                combo.setText(text);
            }
        }
    }

    private void saveInputHistory() {
        for (Map.Entry<String, List<Combo>> e : this.fieldsWithHistory.entrySet()) {
            Combo combo2;
            String id = e.getKey();
            LinkedHashSet<String> history = new LinkedHashSet<String>(15);
            for (Combo combo2 : e.getValue()) {
                String lastValue = combo2.getText();
                if (lastValue == null || lastValue.trim().length() <= 0) continue;
                history.add(lastValue);
            }
            combo2 = e.getValue().iterator().next();
            String[] items = combo2.getItems();
            int j = 0;
            while (j < items.length && history.size() < 15) {
                history.add(items[j]);
                ++j;
            }
            this.dialogSettings.put(id, history.toArray(new String[history.size()]));
        }
    }

    protected void addFieldWithHistory(String id, Combo combo) {
        if (combo != null) {
            List<Combo> combos = this.fieldsWithHistory.get(id);
            if (combos == null) {
                combos = new ArrayList<Combo>();
                this.fieldsWithHistory.put(id, combos);
            }
            combos.add(combo);
        }
    }

    protected String validateArtifactIdInput(String text) {
        return this.validateIdInput(text, true);
    }

    protected String validateGroupIdInput(String text) {
        return this.validateIdInput(text, false);
    }

    private String validateIdInput(String text, boolean artifact) {
        if (text == null || text.length() == 0) {
            return artifact ? Messages.wizardProjectPageMaven2ValidatorArtifactID : Messages.wizardProjectPageMaven2ValidatorGroupID;
        }
        if (text.contains(" ")) {
            return artifact ? Messages.wizardProjectPageMaven2ValidatorArtifactIDnospaces : Messages.wizardProjectPageMaven2ValidatorGroupIDnospaces;
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(text, 4);
        if (!nameStatus.isOK()) {
            return NLS.bind((String)(artifact ? Messages.wizardProjectPageMaven2ValidatorArtifactIDinvalid : Messages.wizardProjectPageMaven2ValidatorGroupIDinvalid), (Object)nameStatus.getMessage());
        }
        if (!text.matches("[A-Za-z0-9_\\-.]+")) {
            return NLS.bind((String)(artifact ? Messages.wizardProjectPageMaven2ValidatorArtifactIDinvalid : Messages.wizardProjectPageMaven2ValidatorGroupIDinvalid), (Object)text);
        }
        return null;
    }
}

