/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.linuxtools.internal.docker.editor.Activator;
import org.eclipse.linuxtools.internal.docker.editor.DockerConfiguration;
import org.eclipse.linuxtools.internal.docker.editor.DockerDocumentProvider;
import org.eclipse.linuxtools.internal.docker.editor.syntax.SyntaxProblemReporter;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class DockerEditor
extends TextEditor {
    public DockerEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new DockerConfiguration(this));
        this.setDocumentProvider((IDocumentProvider)new DockerDocumentProvider());
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            IResource resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            new SyntaxProblemReporter().checkAndApply(document, 0, document.getLength(), resource);
        }
        catch (CoreException | BadLocationException e) {
            Activator.log(4, "Failed to perform syntax check", e);
        }
        super.doSave(progressMonitor);
    }
}

