/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.locks.graph;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphEdge;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;

public class LockGraphNode {
    private int level;
    private int span;
    private String title;
    private DBAServerLock lock;
    private LevelPosition levelPosition;
    private List<LockGraphEdge> sourceEdges;
    private List<LockGraphEdge> targetEdges;

    public LevelPosition getLevelPosition() {
        return this.levelPosition;
    }

    public void setLevelPosition(LevelPosition levelPosition) {
        this.levelPosition = levelPosition;
    }

    public int getLevel() {
        return this.level;
    }

    public LockGraphNode(DBAServerLock lock) {
        this.lock = lock;
        this.level = 0;
        this.span = 0;
        this.title = lock.getTitle();
        this.sourceEdges = new ArrayList<LockGraphEdge>();
        this.targetEdges = new ArrayList<LockGraphEdge>();
        this.levelPosition = LevelPosition.CENTER;
    }

    public LockGraphNode(String title, int level, int span) {
        this.level = level;
        this.span = span;
        this.title = title;
        this.sourceEdges = new ArrayList<LockGraphEdge>();
        this.targetEdges = new ArrayList<LockGraphEdge>();
    }

    public void addSourceEdge(LockGraphEdge sourceEdge) {
        this.sourceEdges.add(sourceEdge);
    }

    public void addTargetEdge(LockGraphEdge targetEdge) {
        this.targetEdges.add(targetEdge);
    }

    public List<LockGraphEdge> getSourceEdges() {
        return this.sourceEdges;
    }

    public List<LockGraphEdge> getTargetEdges() {
        return this.targetEdges;
    }

    public void removeSourceEdge(LockGraphEdge sourceEdge) {
        this.sourceEdges.remove(sourceEdge);
    }

    public void removeTargetEdge(LockGraphEdge targetEdge) {
        this.targetEdges.remove(targetEdge);
    }

    public int getSpan() {
        return this.span;
    }

    public String getTitle() {
        return this.title;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public DBAServerLock getLock() {
        return this.lock;
    }

    public static enum LevelPosition {
        LEFT,
        CENTER,
        RIGHT;

    }
}

