/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.NativeClientFileDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.utils.ContentUtils;

public class NativeClientDistributionDescriptor {
    private static final Log log = Log.getLog(NativeClientDistributionDescriptor.class);
    private final List<NativeClientFileDescriptor> files = new ArrayList<NativeClientFileDescriptor>();
    private OSDescriptor os;
    private String targetPath;
    private String remotePath;
    private String resourcePath;

    public NativeClientDistributionDescriptor(IConfigurationElement config) {
        String osName = config.getAttribute("os");
        this.os = osName == null ? null : new OSDescriptor(osName, config.getAttribute("arch"));
        this.targetPath = config.getAttribute("targetPath");
        this.remotePath = config.getAttribute("remotePath");
        this.resourcePath = config.getAttribute("resourcePath");
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("file");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement fileElement = iConfigurationElementArray[n2];
            if (DriverUtils.matchesBundle(fileElement)) {
                this.files.add(new NativeClientFileDescriptor(fileElement));
            }
            ++n2;
        }
    }

    public OSDescriptor getOs() {
        return this.os;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean downloadFiles(DBRProgressMonitor monitor, DBPNativeClientLocation location) throws DBException, InterruptedException {
        File targetFile;
        String fileName;
        File targetPath = location.getPath();
        ArrayList<NativeClientFileDescriptor> filesToDownload = new ArrayList<NativeClientFileDescriptor>();
        for (NativeClientFileDescriptor file : this.files) {
            fileName = file.getName();
            targetFile = new File(targetPath, fileName);
            if (targetFile.exists()) continue;
            filesToDownload.add(file);
        }
        if (filesToDownload.isEmpty()) {
            return true;
        }
        if (!targetPath.exists() && !targetPath.mkdirs()) {
            throw new DBException("Can't create target folder '" + targetPath.getAbsolutePath() + "'");
        }
        int i = 0;
        while (i < filesToDownload.size()) {
            block36: {
                String fileRemotePath;
                block34: {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    NativeClientFileDescriptor file = (NativeClientFileDescriptor)filesToDownload.get(i);
                    fileName = file.getName();
                    targetFile = new File(targetPath, fileName);
                    fileRemotePath = String.valueOf(this.remotePath) + "/" + file.getName();
                    String localResourcePath = String.valueOf(this.resourcePath) + "/" + file.getName();
                    URL url = DataSourceProviderRegistry.getInstance().findResourceURL(localResourcePath);
                    if (url != null) {
                        try {
                            url = FileLocator.toFileURL((URL)url);
                            File localFile = new File(url.getFile());
                            if (!localFile.exists()) break block34;
                            try {
                                Throwable throwable = null;
                                Object var14_18 = null;
                                try {
                                    FileInputStream is = new FileInputStream(localFile);
                                    try {
                                        Throwable throwable2 = null;
                                        Object var17_24 = null;
                                        try (FileOutputStream os = new FileOutputStream(targetFile);){
                                            ContentUtils.copyStreams((InputStream)is, (long)localFile.length(), (OutputStream)os, (DBRProgressMonitor)monitor);
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                            } else if (throwable2 != throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                        break block36;
                                    }
                                    catch (Throwable throwable4) {
                                        throw throwable4;
                                    }
                                    finally {
                                        if (is != null) {
                                            ((InputStream)is).close();
                                        }
                                        break block36;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable == null) {
                                        throwable = throwable5;
                                    } else if (throwable != throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException e) {
                                if (targetFile.exists() && !targetFile.delete()) {
                                    log.debug((Object)("Error deleting client file '" + targetFile.getAbsolutePath() + "'"));
                                }
                                log.debug((Object)("IO error copying resource file '" + localResourcePath + "'"), (Throwable)e);
                            }
                        }
                        catch (IOException ex) {
                            log.debug((Object)("Error locating resource file '" + localResourcePath + "'"), (Throwable)ex);
                        }
                    }
                }
                if (fileRemotePath.startsWith("repo:/")) {
                    fileRemotePath = fileRemotePath.substring("repo:/".length());
                    String primarySource = DriverDescriptor.getDriversPrimarySource();
                    if (!primarySource.endsWith("/") && !fileRemotePath.startsWith("/")) {
                        primarySource = String.valueOf(primarySource) + '/';
                    }
                    String externalURL = String.valueOf(primarySource) + fileRemotePath;
                    String taskName = "Download native client file '" + fileName + "'" + " (" + (i + 1) + "/" + filesToDownload.size() + ")";
                    monitor.beginTask(taskName, 1);
                    try {
                        WebUtils.downloadRemoteFile((DBRProgressMonitor)monitor, (String)taskName, (String)externalURL, (File)targetFile, null);
                    }
                    catch (IOException e) {
                        log.debug((Object)("Error downloading file '" + fileName + "'"), (Throwable)e);
                        throw new DBException("Error downloading file '" + fileName + "': " + e.getMessage());
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.os.toString();
    }
}

