/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.tools.maintenance.DB2BaseTableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2TruncateDialog
extends DB2BaseTableToolDialog {
    private Button dlgStorageDrop;
    private Button dlgStorageReuse;
    private Button dlgTriggersDelete;
    private Button dlgTriggersRestrict;

    DB2TruncateDialog(IWorkbenchPartSite partSite, Collection<DB2Table> selectedTables) {
        super(partSite, DB2Messages.dialog_table_tools_truncate_title, selectedTables);
    }

    protected void createControls(Composite parent) {
        Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)DB2Messages.dialog_table_tools_options, (int)1, (int)0, (int)0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)optionsGroup, 2);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        UIUtils.createLabel((Composite)composite, (String)DB2Messages.dialog_table_tools_truncate_storage_title).setLayoutData((Object)new GridData(2));
        Composite groupCols = new Composite(composite, 0);
        groupCols.setLayout((Layout)new RowLayout(512));
        this.dlgStorageDrop = new Button(groupCols, 16);
        this.dlgStorageDrop.setText(DB2Messages.dialog_table_tools_truncate_storage_drop);
        this.dlgStorageDrop.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgStorageReuse = new Button(groupCols, 16);
        this.dlgStorageReuse.setText(DB2Messages.dialog_table_tools_truncate_storage_reuse);
        this.dlgStorageReuse.addSelectionListener(this.SQL_CHANGE_LISTENER);
        UIUtils.createLabel((Composite)composite, (String)DB2Messages.dialog_table_tools_truncate_triggers_title).setLayoutData((Object)new GridData(2));
        Composite groupIx = new Composite(composite, 0);
        groupIx.setLayout((Layout)new RowLayout(512));
        this.dlgTriggersDelete = new Button(groupIx, 16);
        this.dlgTriggersDelete.setText(DB2Messages.dialog_table_tools_truncate_triggers_ignore);
        this.dlgTriggersDelete.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgTriggersRestrict = new Button(groupIx, 16);
        this.dlgTriggersRestrict.setText(DB2Messages.dialog_table_tools_truncate_triggers_restrict);
        this.dlgTriggersRestrict.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgStorageDrop.setSelection(true);
        this.dlgTriggersDelete.setSelection(true);
        this.createObjectsSelector(parent);
    }

    protected void generateObjectCommand(List<String> lines, DB2Table db2Table) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("TRUNCATE TABLE ").append(db2Table.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (this.dlgStorageDrop.getSelection()) {
            sb.append(" DROP STORAGE");
        }
        if (this.dlgStorageReuse.getSelection()) {
            sb.append(" REUSE STORAGE");
        }
        if (this.dlgTriggersDelete.getSelection()) {
            sb.append(" IGNORE DELETE TRIGGERS");
        }
        if (this.dlgTriggersRestrict.getSelection()) {
            sb.append(" RESTRICT WHEN DELETE TRIGGERS");
        }
        sb.append(" CONTINUE IDENTITY IMMEDIATE");
        lines.add(sb.toString());
    }

    protected boolean needsRefreshOnFinish() {
        return true;
    }
}

