/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanNode;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanStatement;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class DB2PlanAnalyser
extends AbstractExecutionPlan {
    private static final Log LOG = Log.getLog(DB2PlanAnalyser.class);
    private static String PT_DELETE;
    private static final String PT_EXPLAIN = "EXPLAIN PLAN SET QUERYNO = %d FOR %s";
    private static final String SEL_STMT = "SELECT * FROM %s.EXPLAIN_STATEMENT WHERE QUERYNO = ? AND EXPLAIN_LEVEL = 'P' WITH UR";
    private static AtomicInteger STMT_NO_GEN;
    private String query;
    private String planTableSchema;
    private List<DB2PlanNode> listNodes;
    private DB2PlanStatement db2PlanStatement;

    static {
        STMT_NO_GEN = new AtomicInteger(Long.valueOf(System.currentTimeMillis() / 10000000L).intValue());
        StringBuilder sb = new StringBuilder(256);
        sb.append("DELETE");
        sb.append("  FROM %s.EXPLAIN_INSTANCE I");
        sb.append(" WHERE EXISTS (SELECT 1");
        sb.append("                 FROM %s.EXPLAIN_STATEMENT S");
        sb.append("                WHERE S.EXPLAIN_TIME = I.EXPLAIN_TIME");
        sb.append("                  AND S.SOURCE_NAME = I.SOURCE_NAME");
        sb.append("                  AND S.SOURCE_SCHEMA = I.SOURCE_SCHEMA");
        sb.append("                  AND S.SOURCE_VERSION = I.SOURCE_VERSION");
        sb.append("                  AND QUERYNO = ?)");
        PT_DELETE = sb.toString();
    }

    public DB2PlanAnalyser(String query, String planTableSchema) {
        this.query = query;
        this.planTableSchema = planTableSchema;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.duration".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        if ("plan.duration.measure".equals(feature)) {
            return "ms";
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return String.format(PT_EXPLAIN, STMT_NO_GEN.get(), this.query);
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.listNodes;
    }

    public void explain(JDBCSession session) throws DBCException {
        Integer stmtNo = STMT_NO_GEN.incrementAndGet();
        String explainStmt = String.format(PT_EXPLAIN, stmtNo, this.query);
        LOG.debug((Object)("Schema=" + this.planTableSchema + " : " + explainStmt));
        try {
            JDBCPreparedStatement dbStat;
            this.cleanExplainTables(session, stmtNo, this.planTableSchema);
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                dbStat = session.prepareStatement(explainStmt);
                try {
                    dbStat.execute();
                }
                finally {
                    if (dbStat != null) {
                        dbStat.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_8 = null;
            try {
                dbStat = session.prepareStatement(String.format(SEL_STMT, this.planTableSchema));
                try {
                    dbStat.setInt(1, stmtNo.intValue());
                    Throwable throwable3 = null;
                    Object var8_14 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        dbResult.next();
                        this.db2PlanStatement = new DB2PlanStatement(session, dbResult, this.planTableSchema);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                finally {
                    if (dbStat != null) {
                        dbStat.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
            this.listNodes = this.db2PlanStatement.buildNodes();
            this.cleanExplainTables(session, stmtNo, this.planTableSchema);
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)session.getDataSource());
        }
    }

    private void cleanExplainTables(JDBCSession session, Integer stmtNo, String planTableSchema) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(String.format(PT_DELETE, planTableSchema, planTableSchema));){
            dbStat.setInt(1, stmtNo.intValue());
            dbStat.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

