/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCUtils {
    private static final Log log = Log.getLog(JDBCUtils.class);
    private static final Map<String, Integer> badColumnNames = new HashMap<String, Integer>();

    @Nullable
    public static String safeGetString(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getString(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetStringTrimmed(ResultSet dbResult, String columnName) {
        try {
            String value = dbResult.getString(columnName);
            if (value != null && !value.isEmpty()) {
                return value.trim();
            }
            return value;
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetString(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getString(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetStringTrimmed(ResultSet dbResult, int columnIndex) {
        try {
            String value = dbResult.getString(columnIndex);
            if (value != null && !value.isEmpty()) {
                return value.trim();
            }
            return value;
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    public static int safeGetInt(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getInt(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0;
        }
    }

    public static int safeGetInt(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getInt(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0;
        }
    }

    @Nullable
    public static Integer safeGetInteger(ResultSet dbResult, String columnName) {
        int result;
        block3: {
            try {
                result = dbResult.getInt(columnName);
                if (!dbResult.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                JDBCUtils.debugColumnRead(dbResult, columnName, e);
                return null;
            }
        }
        return result;
    }

    @Nullable
    public static Integer safeGetInteger(ResultSet dbResult, int columnIndex) {
        int result;
        block3: {
            try {
                result = dbResult.getInt(columnIndex);
                if (!dbResult.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
                return null;
            }
        }
        return result;
    }

    public static long safeGetLong(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getLong(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0L;
        }
    }

    public static long safeGetLong(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getLong(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0L;
        }
    }

    @Nullable
    public static Long safeGetLongNullable(ResultSet dbResult, String columnName) {
        try {
            long result = dbResult.getLong(columnName);
            return dbResult.wasNull() ? null : Long.valueOf(result);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    public static double safeGetDouble(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getDouble(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0.0;
        }
    }

    public static double safeGetDouble(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getDouble(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0.0;
        }
    }

    public static float safeGetFloat(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getFloat(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0.0f;
        }
    }

    public static float safeGetFloat(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getFloat(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0.0f;
        }
    }

    @Nullable
    public static BigDecimal safeGetBigDecimal(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getBigDecimal(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static BigDecimal safeGetBigDecimal(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getBigDecimal(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName) {
        return JDBCUtils.safeGetBoolean(dbResult, columnName, false);
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName, boolean defValue) {
        try {
            return dbResult.getBoolean(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return defValue;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getBoolean(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return false;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName, String trueValue) {
        try {
            String strValue = dbResult.getString(columnName);
            return strValue != null && strValue.startsWith(trueValue);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return false;
        }
    }

    @Nullable
    public static byte[] safeGetBytes(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getBytes(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Timestamp safeGetTimestamp(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getTimestamp(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Timestamp safeGetTimestamp(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getTimestamp(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Date safeGetDate(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getDate(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Date safeGetDate(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getDate(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Time safeGetTime(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getTime(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Time safeGetTime(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getTime(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static SQLXML safeGetXML(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getSQLXML(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static SQLXML safeGetXML(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getSQLXML(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetObject(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getObject(columnName);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetObject(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getObject(columnIndex);
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static <T> T safeGetArray(ResultSet dbResult, String columnName) {
        try {
            Array array = dbResult.getArray(columnName);
            return (T)(array == null ? null : array.getArray());
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetArray(ResultSet dbResult, int columnIndex) {
        try {
            Array array = dbResult.getArray(columnIndex);
            return array == null ? null : array.getArray();
        }
        catch (SQLException e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static String normalizeIdentifier(@Nullable String value) {
        return value == null ? null : value.trim();
    }

    public static void dumpResultSet(ResultSet dbResult) {
        try {
            ResultSetMetaData md = dbResult.getMetaData();
            int count = md.getColumnCount();
            JDBCUtils.dumpResultSetMetaData(dbResult);
            while (dbResult.next()) {
                int i = 1;
                while (i <= count) {
                    String colValue = dbResult.getString(i);
                    System.out.print(String.valueOf(colValue) + "\t");
                    ++i;
                }
                System.out.println();
            }
            System.out.println();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void dumpResultSetMetaData(ResultSet dbResult) {
        try {
            ResultSetMetaData md = dbResult.getMetaData();
            int count = md.getColumnCount();
            int i = 1;
            while (i <= count) {
                System.out.print(String.valueOf(md.getColumnName(i)) + " [" + md.getColumnTypeName(i) + "]\t");
                ++i;
            }
            System.out.println();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean isConnectionAlive(DBPDataSource dataSource, Connection connection) {
        try {
            if (connection == null || connection.isClosed()) {
                return false;
            }
        }
        catch (SQLException e) {
            log.debug(e);
            return false;
        }
        for (DBPDataSourceTask task : dataSource.getContainer().getTasks()) {
            if (!task.isActiveTask()) continue;
            return true;
        }
        String testSQL = dataSource instanceof SQLDataSource ? ((SQLDataSource)dataSource).getSQLDialect().getTestSQL() : null;
        int invalidateTimeout = dataSource.getContainer().getPreferenceStore().getInt("connection.validation.timeout");
        boolean[] isValid = new boolean[1];
        RuntimeUtils.runTask(monitor -> {
            block14: {
                try {
                    if (!CommonUtils.isEmpty((String)testSQL)) {
                        Throwable throwable = null;
                        Object var6_7 = null;
                        try (Statement dbStat = connection.createStatement();){
                            dbStat.execute(testSQL);
                            blArray[0] = true;
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        blArray[0] = connection.isValid(invalidateTimeout);
                    }
                    catch (Throwable throwable) {
                        connection.getMetaData().getTables(null, null, "DBEAVERFAKETABLENAMEFORPING", null);
                        blArray[0] = true;
                    }
                }
                catch (SQLException sQLException) {
                    blArray[0] = false;
                }
            }
        }, "Ping connection " + dataSource.getContainer().getName(), invalidateTimeout + 2000, true);
        return isValid[0];
    }

    public static void scrollResultSet(ResultSet dbResult, long offset, boolean forceFetch) throws SQLException {
        boolean scrolled = false;
        if (!forceFetch) {
            try {
                scrolled = dbResult.absolute((int)offset);
            }
            catch (IncompatibleClassChangeError | UnsupportedOperationException | SQLException e) {
                log.debug(e.getMessage());
            }
        }
        if (!scrolled) {
            long i = 1L;
            while (i <= offset) {
                try {
                    dbResult.next();
                }
                catch (SQLException e) {
                    throw new SQLException("Can't scroll result set to row " + offset, e);
                }
                ++i;
            }
        }
    }

    public static void reportWarnings(JDBCSession session, SQLWarning rootWarning) {
        SQLWarning warning = rootWarning;
        while (warning != null) {
            if (warning.getMessage() != null || warning.getErrorCode() != 0) {
                log.warn("SQL Warning (DataSource: " + session.getDataSource().getContainer().getName() + "; Code: " + warning.getErrorCode() + "; State: " + warning.getSQLState() + "): " + warning.getLocalizedMessage());
            }
            warning = warning.getNextWarning();
        }
    }

    @NotNull
    public static String limitQueryLength(@NotNull String query, int maxLength) {
        return query.length() <= maxLength ? query : query.substring(0, maxLength);
    }

    public static DBSForeignKeyModifyRule getCascadeFromNum(int num) {
        switch (num) {
            case 3: {
                return DBSForeignKeyModifyRule.NO_ACTION;
            }
            case 0: {
                return DBSForeignKeyModifyRule.CASCADE;
            }
            case 2: {
                return DBSForeignKeyModifyRule.SET_NULL;
            }
            case 4: {
                return DBSForeignKeyModifyRule.SET_DEFAULT;
            }
            case 1: {
                return DBSForeignKeyModifyRule.RESTRICT;
            }
        }
        return DBSForeignKeyModifyRule.UNKNOWN;
    }

    public static void executeSQL(Connection session, String sql, Object ... params) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    dbStat.setObject(i + 1, params[i]);
                    ++i;
                }
            }
            dbStat.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void executeProcedure(Connection session, String sql) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CallableStatement dbStat = session.prepareCall(sql);){
            dbStat.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeQuery(Connection session, String sql, Object ... params) throws SQLException {
        var3_3 = null;
        var4_5 = null;
        try {
            dbStat = session.prepareStatement(sql);
            try {
                if (params != null) {
                    i = 0;
                    while (i < params.length) {
                        dbStat.setObject(i + 1, params[i]);
                        ++i;
                    }
                }
                var6_9 = null;
                var7_11 = null;
                try {
                    resultSet = dbStat.executeQuery();
                    try {
                        if (resultSet.next()) {
                            v0 = resultSet.getObject(1);
                            if (dbStat == null) return (T)v0;
                            dbStat.close();
                            return (T)v0;
                        }
                        ** try [egrp 5[TRYBLOCK] [2 : 119->133)] { 
                    }
lbl27:
                    // 2 sources

                    catch (Throwable var6_10) {
                        throw var6_10;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (dbStat == null) return null;
                        dbStat.close();
                        return null;
                    }
                }
                catch (Throwable var7_12) {
                    if (var6_9 == null) {
                        var6_9 = var7_12;
                        throw var6_9;
                    }
                    if (var6_9 == var7_12) throw var6_9;
                    var6_9.addSuppressed(var7_12);
                    throw var6_9;
                }
            }
            catch (Throwable var3_4) {
                if (dbStat == null) throw var3_4;
                dbStat.close();
                throw var3_4;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
                throw var3_3;
            }
            if (var3_3 == var4_6) throw var3_3;
            var3_3.addSuppressed(var4_6);
            throw var3_3;
        }
    }

    public static void executeStatement(Connection session, String sql) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement dbStat = session.createStatement();){
            dbStat.execute(sql);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String queryString(JDBCSession session, String sql, Object ... args) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            try {
                if (args != null) {
                    int i = 0;
                    while (i < args.length) {
                        dbStat.setObject(i + 1, args[i]);
                        ++i;
                    }
                }
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCResultSet resultSet = dbStat.executeQuery();){
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if (dbStat == null) return string;
                        dbStat.close();
                        return string;
                    }
                    if (dbStat == null) return null;
                    dbStat.close();
                    return null;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (dbStat == null) throw throwable4;
                dbStat.close();
                throw throwable4;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T queryObject(JDBCSession session, String sql, Object ... args) throws SQLException {
        var3_3 = null;
        var4_5 = null;
        try {
            dbStat = session.prepareStatement(sql);
            try {
                if (args != null) {
                    i = 0;
                    while (i < args.length) {
                        dbStat.setObject(i + 1, args[i]);
                        ++i;
                    }
                }
                var6_9 = null;
                var7_11 = null;
                try {
                    resultSet = dbStat.executeQuery();
                    try {
                        if (resultSet.next()) {
                            v0 = resultSet.getObject(1);
                            if (dbStat == null) return (T)v0;
                            dbStat.close();
                            return (T)v0;
                        }
                        ** try [egrp 5[TRYBLOCK] [2 : 119->133)] { 
                    }
lbl27:
                    // 2 sources

                    catch (Throwable var6_10) {
                        throw var6_10;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (dbStat == null) return null;
                        dbStat.close();
                        return null;
                    }
                }
                catch (Throwable var7_12) {
                    if (var6_9 == null) {
                        var6_9 = var7_12;
                        throw var6_9;
                    }
                    if (var6_9 == var7_12) throw var6_9;
                    var6_9.addSuppressed(var7_12);
                    throw var6_9;
                }
            }
            catch (Throwable var3_4) {
                if (dbStat == null) throw var3_4;
                dbStat.close();
                throw var3_4;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
                throw var3_3;
            }
            if (var3_3 == var4_6) throw var3_3;
            var3_3.addSuppressed(var4_6);
            throw var3_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugColumnRead(ResultSet dbResult, String columnName, SQLException error) {
        String colFullId = columnName;
        if (dbResult instanceof JDBCResultSet) {
            colFullId = String.valueOf(colFullId) + ":" + ((JDBCResultSet)dbResult).getSession().getDataSource().getContainer().getId();
        }
        Map<String, Integer> map = badColumnNames;
        synchronized (map) {
            Integer errorCount = badColumnNames.get(colFullId);
            if (errorCount == null) {
                log.debug("Can't get column '" + columnName + "': " + error.getMessage());
            }
            badColumnNames.put(colFullId, errorCount == null ? 0 : errorCount + 1);
        }
    }

    private static void debugColumnRead(ResultSet dbResult, int columnIndex, SQLException error) {
        JDBCUtils.debugColumnRead(dbResult, "#" + columnIndex, error);
    }

    public static void appendFilterClause(StringBuilder sql, DBSObjectFilter filter, String columnAlias, boolean firstClause) {
        List<String> exclude;
        if (filter.isNotApplicable()) {
            return;
        }
        if (filter.hasSingleMask()) {
            if (columnAlias != null) {
                firstClause = SQLUtils.appendFirstClause(sql, firstClause);
                sql.append(columnAlias);
            }
            SQLUtils.appendLikeCondition(sql, filter.getSingleMask(), false);
            return;
        }
        List<String> include = filter.getInclude();
        if (!CommonUtils.isEmpty(include)) {
            if (columnAlias != null) {
                firstClause = SQLUtils.appendFirstClause(sql, firstClause);
            }
            sql.append("(");
            int i = 0;
            int includeSize = include.size();
            while (i < includeSize) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                if (columnAlias != null) {
                    sql.append(columnAlias);
                }
                SQLUtils.appendLikeCondition(sql, include.get(i), false);
                ++i;
            }
            sql.append(")");
        }
        if (!CommonUtils.isEmpty(exclude = filter.getExclude())) {
            if (columnAlias != null) {
                SQLUtils.appendFirstClause(sql, firstClause);
            }
            sql.append("NOT (");
            int i = 0;
            int excludeSize = exclude.size();
            while (i < excludeSize) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                if (columnAlias != null) {
                    sql.append(columnAlias);
                }
                SQLUtils.appendLikeCondition(sql, exclude.get(i), false);
                ++i;
            }
            sql.append(")");
        }
    }

    public static void setFilterParameters(PreparedStatement statement, int paramIndex, DBSObjectFilter filter) throws SQLException {
        if (filter.isNotApplicable()) {
            return;
        }
        for (String inc : CommonUtils.safeCollection(filter.getInclude())) {
            statement.setString(paramIndex++, SQLUtils.makeSQLLike(inc));
        }
        for (String exc : CommonUtils.safeCollection(filter.getExclude())) {
            statement.setString(paramIndex++, SQLUtils.makeSQLLike(exc));
        }
    }

    public static void rethrowSQLException(Throwable e) throws SQLException {
        if (e instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)e).getTargetException();
            if (targetException instanceof SQLException) {
                throw (SQLException)targetException;
            }
            throw new SQLException(targetException);
        }
    }

    public static DBPDataKind resolveDataKind(@Nullable DBPDataSource dataSource, String typeName, int typeID) {
        if (dataSource == null) {
            return JDBCDataSource.getDataKind(typeName, typeID);
        }
        if (dataSource instanceof DBPDataTypeProvider) {
            return ((DBPDataTypeProvider)((Object)dataSource)).resolveDataKind(typeName, typeID);
        }
        return DBPDataKind.UNKNOWN;
    }

    public static String generateTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull JDBCTable table, Map<String, Object> options, boolean addComments) throws DBException {
        DBERegistry editorsRegistry = table.getDataSource().getContainer().getPlatform().getEditorsRegistry();
        SQLObjectEditor entityEditor = editorsRegistry.getObjectManager(table.getClass(), SQLObjectEditor.class);
        if (entityEditor instanceof SQLTableManager) {
            DBEPersistAction[] ddlActions = ((SQLTableManager)entityEditor).getTableDDL(monitor, table, options);
            return SQLUtils.generateScript(table.getDataSource(), ddlActions, addComments);
        }
        log.debug("Table editor not found for " + table.getClass().getName());
        return SQLUtils.generateCommentLine(table.getDataSource(), "Can't generate DDL: table editor not found for " + table.getClass().getName());
    }

    public static String escapeWildCards(JDBCSession session, String string) {
        if (string == null || string.isEmpty() || string.indexOf(37) == -1 && string.indexOf(95) == -1) {
            return string;
        }
        try {
            SQLDialect dialect = SQLUtils.getDialectFromDataSource(session.getDataSource());
            String escapeStr = dialect.getSearchStringEscape();
            if (CommonUtils.isEmpty((String)escapeStr) || escapeStr.equals(" ")) {
                return string;
            }
            return string.replace("%", String.valueOf(escapeStr) + "%").replace("_", String.valueOf(escapeStr) + "_");
        }
        catch (Throwable e) {
            log.debug("Error escaping wildcard string", e);
            return string;
        }
    }

    public static boolean queryHasOutputParameters(SQLDialect sqlDialect, String sqlQuery) {
        return sqlQuery.contains("?");
    }
}

