/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="MathAbsoluteRandom", summary="Math.abs does not always give a positive result. Please consider other methods for positive random numbers.", severity=BugPattern.SeverityLevel.WARNING)
public class MathAbsoluteRandom
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> RANDOM_ABS_VAL = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.lang.Math").named("abs"), Matchers.argument((int)0, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.util.Random"), Matchers.staticMethod().onClass("java.lang.Math").named("random")}))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (RANDOM_ABS_VAL.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

