Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeybindingsPanel = (function () {
  function KeybindingsPanel() {
    var _this = this;

    _classCallCheck(this, KeybindingsPanel);

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.platformPattern = new RegExp('\\.platform-' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b');

    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.filterKeyBindings(_this.keyBindings, _this.refs.searchEditor.getText());
    }));

    this.disposables.add(atom.keymaps.onDidReloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.disposables.add(atom.keymaps.onDidUnloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.loadKeyBindings();
  }

  _createClass(KeybindingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'keybinding-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-heading icon icon-keyboard' },
            'Keybindings'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'text native-key-bindings', tabIndex: '-1' },
            _etch2['default'].dom('span', { className: 'icon icon-question' }),
            _etch2['default'].dom(
              'span',
              null,
              'You can override these keybindings by copying '
            ),
            _etch2['default'].dom('span', { className: 'icon icon-clippy' }),
            _etch2['default'].dom(
              'span',
              null,
              'and pasting them into '
            ),
            _etch2['default'].dom(
              'a',
              { className: 'link', onclick: this.didClickOpenKeymapFile },
              'your keymap file'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'editor-container' },
            _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor', placeholderText: 'Search keybindings' })
          ),
          _etch2['default'].dom(
            'table',
            { className: 'native-key-bindings table text', tabIndex: '-1' },
            _etch2['default'].dom('col', { className: 'keystroke' }),
            _etch2['default'].dom('col', { className: 'command' }),
            _etch2['default'].dom('col', { className: 'source' }),
            _etch2['default'].dom('col', { className: 'selector' }),
            _etch2['default'].dom(
              'thead',
              null,
              _etch2['default'].dom(
                'tr',
                null,
                _etch2['default'].dom(
                  'th',
                  { className: 'keystroke' },
                  'Keystroke'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'command' },
                  'Command'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'source' },
                  'Source'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'selector' },
                  'Selector'
                )
              )
            ),
            _etch2['default'].dom('tbody', { ref: 'keybindingRows' })
          )
        )
      );
    }
  }, {
    key: 'loadKeyBindings',
    value: function loadKeyBindings() {
      this.refs.keybindingRows.innerHTML = '';
      this.keyBindings = _underscorePlus2['default'].sortBy(atom.keymaps.getKeyBindings(), 'keystrokes');
      this.appendKeyBindings(this.keyBindings);
      this.filterKeyBindings(this.keyBindings, this.refs.searchEditor.getText());
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'filterKeyBindings',
    value: function filterKeyBindings(keyBindings, filterString) {
      this.refs.keybindingRows.innerHTML = '';
      for (var keyBinding of keyBindings) {
        var selector = keyBinding.selector;
        var keystrokes = keyBinding.keystrokes;
        var command = keyBinding.command;
        var source = keyBinding.source;

        source = KeybindingsPanel.determineSource(source);
        var searchString = ('' + selector + keystrokes + command + source).toLowerCase();
        if (!searchString) {
          continue;
        }

        var keywords = filterString.trim().toLowerCase().split(' ');
        if (keywords.every(function (keyword) {
          return searchString.indexOf(keyword) !== -1;
        })) {
          this.appendKeyBinding(keyBinding);
        }
      }
    }
  }, {
    key: 'appendKeyBindings',
    value: function appendKeyBindings(keyBindings) {
      for (var keyBinding of keyBindings) {
        this.appendKeyBinding(keyBinding);
      }
    }
  }, {
    key: 'appendKeyBinding',
    value: function appendKeyBinding(keyBinding) {
      if (!this.showSelector(keyBinding.selector)) {
        return;
      }

      var element = this.elementForKeyBinding(keyBinding);
      element.dataset.keyBinding = keyBinding;
      this.refs.keybindingRows.appendChild(element);
    }
  }, {
    key: 'showSelector',
    value: function showSelector(selector) {
      var _this2 = this;

      var segments = undefined;
      if (selector) {
        segments = selector.split(',') || [];
      } else {
        segments = [];
      }

      return segments.some(function (s) {
        return _this2.platformPattern.test(s) || !_this2.otherPlatformPattern.test(s);
      });
    }
  }, {
    key: 'elementForKeyBinding',
    value: function elementForKeyBinding(keyBinding) {
      var selector = keyBinding.selector;
      var keystrokes = keyBinding.keystrokes;
      var command = keyBinding.command;
      var source = keyBinding.source;

      source = KeybindingsPanel.determineSource(source);

      var tr = document.createElement('tr');
      if (source === 'User') {
        tr.classList.add('is-user');
      }

      var keystrokeTd = document.createElement('td');
      keystrokeTd.classList.add('keystroke');

      var copyIcon = document.createElement('span');
      copyIcon.classList.add('icon', 'icon-clippy', 'copy-icon');
      copyIcon.onclick = function () {
        var content = undefined;
        var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());

        var escapeCSON = function escapeCSON(input) {
          return JSON.stringify(input).slice(1, -1) // Remove wrapping double quotes
          .replace(/\\"/g, '"') // Unescape double quotes
          .replace(/'/g, '\\\''); // Escape single quotes
        };

        if (keymapExtension === '.cson') {
          content = '\'' + escapeCSON(selector) + '\':\n  \'' + escapeCSON(keystrokes) + '\': \'' + escapeCSON(command) + '\'';
        } else {
          content = JSON.stringify(selector) + ': {\n  ' + JSON.stringify(keystrokes) + ': ' + JSON.stringify(command) + '\n}';
        }
        return atom.clipboard.write(content);
      };
      keystrokeTd.appendChild(copyIcon);

      var keystrokesSpan = document.createElement('span');
      keystrokesSpan.textContent = keystrokes;
      keystrokeTd.appendChild(keystrokesSpan);
      tr.appendChild(keystrokeTd);

      var commandTd = document.createElement('td');
      commandTd.classList.add('command');
      commandTd.textContent = command;
      tr.appendChild(commandTd);

      var sourceTd = document.createElement('td');
      sourceTd.classList.add('source');
      sourceTd.textContent = source;
      tr.appendChild(sourceTd);

      var selectorTd = document.createElement('td');
      selectorTd.classList.add('selector');
      selectorTd.textContent = selector;
      tr.appendChild(selectorTd);

      return tr;
    }
  }, {
    key: 'didClickOpenKeymapFile',
    value: function didClickOpenKeymapFile(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-keymap');
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }

    // Private: Returns a user friendly description of where a keybinding was
    // loaded from.
    //
    // * filePath:
    //   The absolute path from which the keymap was loaded
    //
    // Returns one of:
    // * `Core` indicates it comes from a bundled package.
    // * `User` indicates that it was defined by a user.
    // * `<package-name>` the package which defined it.
    // * `Unknown` if an invalid path was passed in.
  }], [{
    key: 'determineSource',
    value: function determineSource(filePath) {
      if (!filePath) {
        return 'Unknown';
      }

      if (filePath.indexOf(_path2['default'].join(atom.getLoadSettings().resourcePath, 'keymaps')) === 0) {
        return 'Core';
      } else if (filePath === atom.keymaps.getUserKeymapPath()) {
        return 'User';
      } else {
        var pathParts = filePath.split(_path2['default'].sep);
        var packageNameIndex = pathParts.length - 3;
        var packageName = pathParts[packageNameIndex] != null ? pathParts[packageNameIndex] : '';
        return _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(packageName));
      }
    }
  }]);

  return KeybindingsPanel;
})();

exports['default'] = KeybindingsPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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