/**
 * Get the argument names from a given function.
 *
 * @param {Function} func - The function to parse.
 * @returns {Array} arg - List of arguments in the function.
 */
module.exports = function(func) {
  // First match everything inside the function argument parens.
  var args = func.toString().match(/([^(])*\(([^)]*)\)/)[2];

  // Split the arguments string into an array comma delimited.
  return args.split(", ").map(function(arg) {
    // Ensure no inline comments are parsed and trim the whitespace.
    return arg.replace(/\/\*.*\*\//, "").trim();
  }).filter(function(arg) {
    // Ensure no undefineds are added.
    return arg;
  });
};
