"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareHeadRefForcePushedEventView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../timeago"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareHeadRefForcePushedEventView extends _react.default.Component {
  render() {
    const {
      actor,
      beforeCommit,
      afterCommit,
      createdAt
    } = this.props.item;
    const {
      headRefName,
      headRepositoryOwner,
      repository
    } = this.props.issueish;
    const branchPrefix = headRepositoryOwner.login !== repository.owner.login ? `${headRepositoryOwner.login}:` : '';
    return _react.default.createElement("div", {
      className: "head-ref-force-pushed-event"
    }, _react.default.createElement(_octicon.default, {
      className: "pre-timeline-item-icon",
      icon: "repo-force-push"
    }), actor && _react.default.createElement("img", {
      className: "author-avatar",
      src: actor.avatarUrl,
      alt: actor.login,
      title: actor.login
    }), _react.default.createElement("span", {
      className: "head-ref-force-pushed-event-header"
    }, _react.default.createElement("span", {
      className: "username"
    }, actor ? actor.login : 'someone'), " force-pushed the ", branchPrefix + headRefName, " branch from ", this.renderCommit(beforeCommit, 'an old commit'), " to", ' ', this.renderCommit(afterCommit, 'a new commit'), " at ", _react.default.createElement(_timeago.default, {
      time: createdAt
    })));
  }

  renderCommit(commit, description) {
    if (!commit) {
      return description;
    }

    return _react.default.createElement("span", {
      className: "sha"
    }, commit.oid.slice(0, 8));
  }

}

exports.BareHeadRefForcePushedEventView = BareHeadRefForcePushedEventView;

_defineProperty(BareHeadRefForcePushedEventView, "propTypes", {
  item: _propTypes.default.shape({
    actor: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string.isRequired,
      login: _propTypes.default.string.isRequired
    }),
    beforeCommit: _propTypes.default.shape({
      oid: _propTypes.default.string.isRequired
    }),
    afterCommit: _propTypes.default.shape({
      oid: _propTypes.default.string.isRequired
    }),
    createdAt: _propTypes.default.string.isRequired
  }).isRequired,
  issueish: _propTypes.default.shape({
    headRefName: _propTypes.default.string.isRequired,
    headRepositoryOwner: _propTypes.default.shape({
      login: _propTypes.default.string.isRequired
    }),
    repository: _propTypes.default.shape({
      owner: _propTypes.default.shape({
        login: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareHeadRefForcePushedEventView, {
  issueish: function () {
    const node = require("./__generated__/headRefForcePushedEventView_issueish.graphql");

    if (node.hash && node.hash !== "4c639070afc4a02cedf062d836d0dd7f") {
      console.error("The definition of 'headRefForcePushedEventView_issueish' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/headRefForcePushedEventView_issueish.graphql");
  },
  item: function () {
    const node = require("./__generated__/headRefForcePushedEventView_item.graphql");

    if (node.hash && node.hash !== "fc403545674c57c1997c870805101ffb") {
      console.error("The definition of 'headRefForcePushedEventView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/headRefForcePushedEventView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImhlYWQtcmVmLWZvcmNlLXB1c2hlZC1ldmVudC12aWV3LmpzIl0sIm5hbWVzIjpbIkJhcmVIZWFkUmVmRm9yY2VQdXNoZWRFdmVudFZpZXciLCJSZWFjdCIsIkNvbXBvbmVudCIsInJlbmRlciIsImFjdG9yIiwiYmVmb3JlQ29tbWl0IiwiYWZ0ZXJDb21taXQiLCJjcmVhdGVkQXQiLCJwcm9wcyIsIml0ZW0iLCJoZWFkUmVmTmFtZSIsImhlYWRSZXBvc2l0b3J5T3duZXIiLCJyZXBvc2l0b3J5IiwiaXNzdWVpc2giLCJicmFuY2hQcmVmaXgiLCJsb2dpbiIsIm93bmVyIiwiYXZhdGFyVXJsIiwicmVuZGVyQ29tbWl0IiwiY29tbWl0IiwiZGVzY3JpcHRpb24iLCJvaWQiLCJzbGljZSIsIlByb3BUeXBlcyIsInNoYXBlIiwic3RyaW5nIiwiaXNSZXF1aXJlZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOzs7Ozs7QUFFTyxNQUFNQSwrQkFBTixTQUE4Q0MsZUFBTUMsU0FBcEQsQ0FBOEQ7QUE0Qm5FQyxFQUFBQSxNQUFNLEdBQUc7QUFDUCxVQUFNO0FBQUNDLE1BQUFBLEtBQUQ7QUFBUUMsTUFBQUEsWUFBUjtBQUFzQkMsTUFBQUEsV0FBdEI7QUFBbUNDLE1BQUFBO0FBQW5DLFFBQWdELEtBQUtDLEtBQUwsQ0FBV0MsSUFBakU7QUFDQSxVQUFNO0FBQUNDLE1BQUFBLFdBQUQ7QUFBY0MsTUFBQUEsbUJBQWQ7QUFBbUNDLE1BQUFBO0FBQW5DLFFBQWlELEtBQUtKLEtBQUwsQ0FBV0ssUUFBbEU7QUFDQSxVQUFNQyxZQUFZLEdBQUdILG1CQUFtQixDQUFDSSxLQUFwQixLQUE4QkgsVUFBVSxDQUFDSSxLQUFYLENBQWlCRCxLQUEvQyxHQUF3RCxHQUFFSixtQkFBbUIsQ0FBQ0ksS0FBTSxHQUFwRixHQUF5RixFQUE5RztBQUNBLFdBQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0UsNkJBQUMsZ0JBQUQ7QUFBUyxNQUFBLFNBQVMsRUFBQyx3QkFBbkI7QUFBNEMsTUFBQSxJQUFJLEVBQUM7QUFBakQsTUFERixFQUVHWCxLQUFLLElBQUk7QUFBSyxNQUFBLFNBQVMsRUFBQyxlQUFmO0FBQStCLE1BQUEsR0FBRyxFQUFFQSxLQUFLLENBQUNhLFNBQTFDO0FBQXFELE1BQUEsR0FBRyxFQUFFYixLQUFLLENBQUNXLEtBQWhFO0FBQXVFLE1BQUEsS0FBSyxFQUFFWCxLQUFLLENBQUNXO0FBQXBGLE1BRlosRUFHRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQ0U7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixPQUE0QlgsS0FBSyxHQUFHQSxLQUFLLENBQUNXLEtBQVQsR0FBaUIsU0FBbEQsQ0FERix3QkFFT0QsWUFBWSxHQUFHSixXQUZ0QixtQkFHUSxLQUFLUSxZQUFMLENBQWtCYixZQUFsQixFQUFnQyxlQUFoQyxDQUhSLFNBSUcsR0FKSCxFQUlRLEtBQUthLFlBQUwsQ0FBa0JaLFdBQWxCLEVBQStCLGNBQS9CLENBSlIsVUFJMkQsNkJBQUMsZ0JBQUQ7QUFBUyxNQUFBLElBQUksRUFBRUM7QUFBZixNQUozRCxDQUhGLENBREY7QUFZRDs7QUFFRFcsRUFBQUEsWUFBWSxDQUFDQyxNQUFELEVBQVNDLFdBQVQsRUFBc0I7QUFDaEMsUUFBSSxDQUFDRCxNQUFMLEVBQWE7QUFDWCxhQUFPQyxXQUFQO0FBQ0Q7O0FBRUQsV0FBTztBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQXVCRCxNQUFNLENBQUNFLEdBQVAsQ0FBV0MsS0FBWCxDQUFpQixDQUFqQixFQUFvQixDQUFwQixDQUF2QixDQUFQO0FBQ0Q7O0FBcERrRTs7OztnQkFBeER0QiwrQixlQUNRO0FBQ2pCUyxFQUFBQSxJQUFJLEVBQUVjLG1CQUFVQyxLQUFWLENBQWdCO0FBQ3BCcEIsSUFBQUEsS0FBSyxFQUFFbUIsbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDckJQLE1BQUFBLFNBQVMsRUFBRU0sbUJBQVVFLE1BQVYsQ0FBaUJDLFVBRFA7QUFFckJYLE1BQUFBLEtBQUssRUFBRVEsbUJBQVVFLE1BQVYsQ0FBaUJDO0FBRkgsS0FBaEIsQ0FEYTtBQUtwQnJCLElBQUFBLFlBQVksRUFBRWtCLG1CQUFVQyxLQUFWLENBQWdCO0FBQzVCSCxNQUFBQSxHQUFHLEVBQUVFLG1CQUFVRSxNQUFWLENBQWlCQztBQURNLEtBQWhCLENBTE07QUFRcEJwQixJQUFBQSxXQUFXLEVBQUVpQixtQkFBVUMsS0FBVixDQUFnQjtBQUMzQkgsTUFBQUEsR0FBRyxFQUFFRSxtQkFBVUUsTUFBVixDQUFpQkM7QUFESyxLQUFoQixDQVJPO0FBV3BCbkIsSUFBQUEsU0FBUyxFQUFFZ0IsbUJBQVVFLE1BQVYsQ0FBaUJDO0FBWFIsR0FBaEIsRUFZSEEsVUFiYztBQWNqQmIsRUFBQUEsUUFBUSxFQUFFVSxtQkFBVUMsS0FBVixDQUFnQjtBQUN4QmQsSUFBQUEsV0FBVyxFQUFFYSxtQkFBVUUsTUFBVixDQUFpQkMsVUFETjtBQUV4QmYsSUFBQUEsbUJBQW1CLEVBQUVZLG1CQUFVQyxLQUFWLENBQWdCO0FBQ25DVCxNQUFBQSxLQUFLLEVBQUVRLG1CQUFVRSxNQUFWLENBQWlCQztBQURXLEtBQWhCLENBRkc7QUFLeEJkLElBQUFBLFVBQVUsRUFBRVcsbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDMUJSLE1BQUFBLEtBQUssRUFBRU8sbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDckJULFFBQUFBLEtBQUssRUFBRVEsbUJBQVVFLE1BQVYsQ0FBaUJDO0FBREgsT0FBaEIsRUFFSkE7QUFIdUIsS0FBaEIsRUFJVEE7QUFUcUIsR0FBaEIsRUFVUEE7QUF4QmMsQzs7ZUFzRE4seUNBQXdCMUIsK0JBQXhCLEVBQXlEO0FBQ3RFYSxFQUFBQSxRQUFRO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQUEsR0FEOEQ7QUFTdEVKLEVBQUFBLElBQUk7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQTtBQVRrRSxDQUF6RCxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IHtncmFwaHFsLCBjcmVhdGVGcmFnbWVudENvbnRhaW5lcn0gZnJvbSAncmVhY3QtcmVsYXknO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuaW1wb3J0IE9jdGljb24gZnJvbSAnLi4vLi4vYXRvbS9vY3RpY29uJztcbmltcG9ydCBUaW1lYWdvIGZyb20gJy4uL3RpbWVhZ28nO1xuXG5leHBvcnQgY2xhc3MgQmFyZUhlYWRSZWZGb3JjZVB1c2hlZEV2ZW50VmlldyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgaXRlbTogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIGFjdG9yOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICBhdmF0YXJVcmw6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgICAgbG9naW46IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIH0pLFxuICAgICAgYmVmb3JlQ29tbWl0OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICBvaWQ6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIH0pLFxuICAgICAgYWZ0ZXJDb21taXQ6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIG9pZDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgfSksXG4gICAgICBjcmVhdGVkQXQ6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICAgIGlzc3VlaXNoOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgaGVhZFJlZk5hbWU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIGhlYWRSZXBvc2l0b3J5T3duZXI6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIGxvZ2luOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICB9KSxcbiAgICAgIHJlcG9zaXRvcnk6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIG93bmVyOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgIGxvZ2luOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgICB9KS5pc1JlcXVpcmVkLFxuICAgIH0pLmlzUmVxdWlyZWQsXG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3Qge2FjdG9yLCBiZWZvcmVDb21taXQsIGFmdGVyQ29tbWl0LCBjcmVhdGVkQXR9ID0gdGhpcy5wcm9wcy5pdGVtO1xuICAgIGNvbnN0IHtoZWFkUmVmTmFtZSwgaGVhZFJlcG9zaXRvcnlPd25lciwgcmVwb3NpdG9yeX0gPSB0aGlzLnByb3BzLmlzc3VlaXNoO1xuICAgIGNvbnN0IGJyYW5jaFByZWZpeCA9IGhlYWRSZXBvc2l0b3J5T3duZXIubG9naW4gIT09IHJlcG9zaXRvcnkub3duZXIubG9naW4gPyBgJHtoZWFkUmVwb3NpdG9yeU93bmVyLmxvZ2lufTpgIDogJyc7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiaGVhZC1yZWYtZm9yY2UtcHVzaGVkLWV2ZW50XCI+XG4gICAgICAgIDxPY3RpY29uIGNsYXNzTmFtZT1cInByZS10aW1lbGluZS1pdGVtLWljb25cIiBpY29uPVwicmVwby1mb3JjZS1wdXNoXCIgLz5cbiAgICAgICAge2FjdG9yICYmIDxpbWcgY2xhc3NOYW1lPVwiYXV0aG9yLWF2YXRhclwiIHNyYz17YWN0b3IuYXZhdGFyVXJsfSBhbHQ9e2FjdG9yLmxvZ2lufSB0aXRsZT17YWN0b3IubG9naW59IC8+fVxuICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJoZWFkLXJlZi1mb3JjZS1wdXNoZWQtZXZlbnQtaGVhZGVyXCI+XG4gICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwidXNlcm5hbWVcIj57YWN0b3IgPyBhY3Rvci5sb2dpbiA6ICdzb21lb25lJ308L3NwYW4+IGZvcmNlLXB1c2hlZFxuICAgICAgICAgIHRoZSB7YnJhbmNoUHJlZml4ICsgaGVhZFJlZk5hbWV9IGJyYW5jaFxuICAgICAgICAgIGZyb20ge3RoaXMucmVuZGVyQ29tbWl0KGJlZm9yZUNvbW1pdCwgJ2FuIG9sZCBjb21taXQnKX0gdG9cbiAgICAgICAgICB7JyAnfXt0aGlzLnJlbmRlckNvbW1pdChhZnRlckNvbW1pdCwgJ2EgbmV3IGNvbW1pdCcpfSBhdCA8VGltZWFnbyB0aW1lPXtjcmVhdGVkQXR9IC8+XG4gICAgICAgIDwvc3Bhbj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJDb21taXQoY29tbWl0LCBkZXNjcmlwdGlvbikge1xuICAgIGlmICghY29tbWl0KSB7XG4gICAgICByZXR1cm4gZGVzY3JpcHRpb247XG4gICAgfVxuXG4gICAgcmV0dXJuIDxzcGFuIGNsYXNzTmFtZT1cInNoYVwiPntjb21taXQub2lkLnNsaWNlKDAsIDgpfTwvc3Bhbj47XG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgY3JlYXRlRnJhZ21lbnRDb250YWluZXIoQmFyZUhlYWRSZWZGb3JjZVB1c2hlZEV2ZW50Vmlldywge1xuICBpc3N1ZWlzaDogZ3JhcGhxbGBcbiAgICBmcmFnbWVudCBoZWFkUmVmRm9yY2VQdXNoZWRFdmVudFZpZXdfaXNzdWVpc2ggb24gUHVsbFJlcXVlc3Qge1xuICAgICAgaGVhZFJlZk5hbWVcbiAgICAgIGhlYWRSZXBvc2l0b3J5T3duZXIgeyBsb2dpbiB9XG4gICAgICByZXBvc2l0b3J5IHsgb3duZXIgeyBsb2dpbiB9IH1cbiAgICB9XG4gIGAsXG5cbiAgaXRlbTogZ3JhcGhxbGBcbiAgICBmcmFnbWVudCBoZWFkUmVmRm9yY2VQdXNoZWRFdmVudFZpZXdfaXRlbSBvbiBIZWFkUmVmRm9yY2VQdXNoZWRFdmVudCB7XG4gICAgICBhY3RvciB7IGF2YXRhclVybCBsb2dpbiB9XG4gICAgICBiZWZvcmVDb21taXQgeyBvaWQgfVxuICAgICAgYWZ0ZXJDb21taXQgeyBvaWQgfVxuICAgICAgY3JlYXRlZEF0XG4gICAgfVxuICBgLFxufSk7XG4iXX0=