"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCommitCommentThreadView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _commitCommentView = _interopRequireDefault(require("./commit-comment-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitCommentThreadView extends _react.default.Component {
  render() {
    const {
      item
    } = this.props;
    return _react.default.createElement("div", {
      className: "commit-comment-thread timeline-item"
    }, item.comments.edges.map((edge, i) => _react.default.createElement(_commitCommentView.default, {
      isReply: i !== 0,
      key: edge.node.id,
      item: edge.node,
      switchToIssueish: this.props.switchToIssueish
    })));
  }

}

exports.BareCommitCommentThreadView = BareCommitCommentThreadView;

_defineProperty(BareCommitCommentThreadView, "propTypes", {
  item: _propTypes.default.shape({
    commit: _propTypes.default.shape({
      oid: _propTypes.default.string.isRequired
    }).isRequired,
    comments: _propTypes.default.shape({
      edges: _propTypes.default.arrayOf(_propTypes.default.shape({
        node: _propTypes.default.object.isRequired
      }).isRequired).isRequired
    }).isRequired
  }).isRequired,
  switchToIssueish: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitCommentThreadView, {
  item: function () {
    const node = require("./__generated__/commitCommentThreadView_item.graphql");

    if (node.hash && node.hash !== "8d9762b31747ddf9be48e163b09a45bc") {
      console.error("The definition of 'commitCommentThreadView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitCommentThreadView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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