"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const ISSUEISH_URL_REGEX = /^(?:https?:\/\/)?github.com\/([^/]+)\/([^/]+)\/(?:issues|pull)\/(\d+)/;

class OpenIssueishDialog extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'accept', 'cancel', 'editorRefs', 'didChangeIssueishUrl');
    this.state = {
      cloneDisabled: false
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.issueishUrlElement) {
      setTimeout(() => this.issueishUrlElement.focus());
    }
  }

  render() {
    return this.renderDialog();
  }

  renderDialog() {
    return _react.default.createElement("div", {
      className: "github-Dialog github-OpenIssueish modal"
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: ".github-OpenIssueish"
    }, _react.default.createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react.default.createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.accept
    })), _react.default.createElement("main", {
      className: "github-DialogInputs"
    }, _react.default.createElement("label", {
      className: "github-DialogLabel github-IssueishUrl"
    }, "Issue or pull request URL:", _react.default.createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('issueishUrl'),
      tabIndex: "1"
    })), this.state.error && _react.default.createElement("span", {
      className: "error"
    }, this.state.error)), _react.default.createElement("div", {
      className: "github-DialogButtons"
    }, _react.default.createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react.default.createElement("button", {
      className: "btn btn-primary icon icon-git-pull-request",
      onClick: this.accept,
      disabled: this.getIssueishUrl().length === 0,
      tabIndex: "2"
    }, "Open Issue or Pull Request")));
  }

  accept() {
    if (this.getIssueishUrl().length === 0) {
      return;
    }

    const parsed = this.parseUrl();

    if (!parsed) {
      this.setState({
        error: 'That is not a valid issue or pull request URL.'
      });
      return;
    }

    const {
      repoOwner,
      repoName,
      issueishNumber
    } = parsed;
    this.props.didAccept({
      repoOwner,
      repoName,
      issueishNumber
    });
  }

  cancel() {
    this.props.didCancel();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;
    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();

      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  didChangeIssueishUrl() {
    this.setState({
      error: null
    });
  }

  parseUrl() {
    const url = this.getIssueishUrl();
    const matches = url.match(ISSUEISH_URL_REGEX);

    if (!matches) {
      return false;
    }

    const [_full, repoOwner, repoName, issueishNumber] = matches; // eslint-disable-line no-unused-vars

    return {
      repoOwner,
      repoName,
      issueishNumber
    };
  }

  getIssueishUrl() {
    return this.issueishUrlEditor ? this.issueishUrlEditor.getText() : '';
  }

}

exports.default = OpenIssueishDialog;

_defineProperty(OpenIssueishDialog, "propTypes", {
  commandRegistry: _propTypes.default.object.isRequired,
  didAccept: _propTypes.default.func,
  didCancel: _propTypes.default.func
});

_defineProperty(OpenIssueishDialog, "defaultProps", {
  didAccept: () => {},
  didCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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