"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _changedFileContainer = _interopRequireDefault(require("../containers/changed-file-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFileItem extends _react.default.Component {
  static buildURI(relPath, workingDirectory, stagingStatus) {
    return 'atom-github://file-patch/' + encodeURIComponent(relPath) + `?workdir=${encodeURIComponent(workingDirectory)}` + `&stagingStatus=${encodeURIComponent(stagingStatus)}`;
  }

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'destroy');
    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.refEditor = new _refHolder.default();
    this.refEditor.observe(editor => {
      this.emitter.emit('did-change-embedded-text-editor', editor);
    });
  }

  getTitle() {
    let title = this.props.stagingStatus === 'staged' ? 'Staged' : 'Unstaged';
    title += ' Changes: ';
    title += this.props.relPath;
    return title;
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  destroy() {
    /* istanbul ignore else */
    if (!this.isDestroyed) {
      this.emitter.emit('did-destroy');
      this.isDestroyed = true;
    }
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react.default.createElement(_changedFileContainer.default, _extends({
      itemType: this.constructor,
      repository: repository,
      destroy: this.destroy,
      refEditor: this.refEditor
    }, this.props));
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  serialize() {
    return {
      deserializer: 'FilePatchControllerStub',
      uri: ChangedFileItem.buildURI(this.props.relPath, this.props.workingDirectory, this.props.stagingStatus)
    };
  }

  getStagingStatus() {
    return this.props.stagingStatus;
  }

  getFilePath() {
    return this.props.relPath;
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  isFilePatchItem() {
    return true;
  }

}

exports.default = ChangedFileItem;

_defineProperty(ChangedFileItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  relPath: _propTypes.default.string.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  stagingStatus: _propTypes.default.oneOf(['staged', 'unstaged']),
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  discardLines: _propTypes.default.func.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  surfaceFileAtPath: _propTypes.default.func.isRequired
});

_defineProperty(ChangedFileItem, "uriPattern", 'atom-github://file-patch/{relPath...}?workdir={workingDirectory}&stagingStatus={stagingStatus}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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