"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _prReviewCommentsContainer = _interopRequireDefault(require("../containers/pr-review-comments-container"));

var _prReviewCommentsView = _interopRequireDefault(require("../views/pr-review-comments-view"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestReviewsController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "_attemptToLoadMoreReviews", () => {
      if (!this.props.relay.hasMore()) {
        return;
      }

      if (this.props.relay.isLoading()) {
        setTimeout(this._loadMoreReviews, _helpers.PAGINATION_WAIT_TIME_MS);
      } else {
        this._loadMoreReviews();
      }
    });

    _defineProperty(this, "accumulateReviews", error => {
      /* istanbul ignore if */
      if (error) {
        // eslint-disable-next-line no-console
        console.error(error);
      } else {
        this._attemptToLoadMoreReviews();
      }
    });

    _defineProperty(this, "_loadMoreReviews", () => {
      this.props.relay.loadMore(_helpers.PAGE_SIZE, this.accumulateReviews);
    });

    _defineProperty(this, "collectComments", ({
      reviewId,
      submittedAt,
      comments,
      fetchingMoreComments
    }) => {
      this.reviewsById.set(reviewId, {
        submittedAt,
        comments,
        fetchingMoreComments
      });
      const stillFetchingReviews = this.props.relay.hasMore();

      if (!stillFetchingReviews) {
        const stillFetchingComments = [...this.reviewsById.values()].some(review => review.fetchingMoreComments);

        if (!stillFetchingComments) {
          this.groupCommentsByThread();
        }
      }
    });

    this.state = {};
    this.reviewsById = new Map();
  }

  componentDidMount() {
    this._attemptToLoadMoreReviews();
  }

  render() {
    if (!this.props.pullRequest || !this.props.pullRequest.reviews) {
      return null;
    }

    const commentThreads = Object.keys(this.state).reverse().map(rootCommentId => {
      return {
        rootCommentId,
        comments: this.state[rootCommentId]
      };
    });
    /** Dealing with comment threading...
      *
      * Threads can have comments belonging to multiple reviews.
      * We need a nested pagination container to fetch comment pages.
      * Upon fetching new comments, the `collectComments` method is called with all comments fetched for that review.
      * Ultimately we want to group comments based on the root comment they are replies to.
      * `renderCommentFetchingContainers` only fetches data and doesn't render any user visible DOM elements.
      * `PullRequestReviewCommentsView` renders the aggregated comment thread data.
    * */

    return _react.default.createElement(_react.Fragment, null, this.renderCommentFetchingContainers(), _react.default.createElement(_prReviewCommentsView.default, _extends({
      commentThreads: commentThreads
    }, this.props)));
  }

  renderCommentFetchingContainers() {
    return this.props.pullRequest.reviews.edges.map(({
      node: review
    }) => {
      return _react.default.createElement(_prReviewCommentsContainer.default, {
        key: review.id,
        review: review,
        collectComments: this.collectComments
      });
    });
  }

  groupCommentsByThread() {
    // we have no guarantees that reviews will return in order so sort them by date.
    const sortedReviews = [...this.reviewsById.values()].sort(this.compareReviewsByDate); // react batches calls to setState and does not update state synchronously
    // therefore we need an intermediate state so we can do checks against keys
    // we have just added.

    const state = {};
    sortedReviews.forEach(({
      comments
    }) => {
      comments.edges.forEach(({
        node: comment
      }) => {
        if (!comment.replyTo) {
          state[comment.id] = [comment];
        } else {
          // Ran into this error when viewing files for https://github.com/numpy/numpy/pull/9998
          // for comment MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDE1MzA1NTUzMw,
          // who's replyTo comment does not exist.
          // Not sure how we'd get into this state -- tried replying to outdated,
          // hidden, deleted, and resolved comments but none of those conditions
          // got us here.
          // It may be that this only affects older pull requests, before something
          // changed with oudated comment behavior.
          // anyhow, do this check and move on with our lives.
          if (!state[comment.replyTo.id]) {
            state[comment.id] = [comment];
          } else {
            state[comment.replyTo.id].push(comment);
          }
        }
      });
    });
    this.setState(state);
  } // compare reviews by date ascending (in order to sort oldest to newest)


  compareReviewsByDate(reviewA, reviewB) {
    const dateA = new Date(reviewA.submittedAt);
    const dateB = new Date(reviewB.submittedAt);

    if (dateA > dateB) {
      return 1;
    } else if (dateB > dateA) {
      return -1;
    } else {
      return 0;
    }
  }

}

exports.default = PullRequestReviewsController;

_defineProperty(PullRequestReviewsController, "propTypes", {
  relay: _propTypes.default.shape({
    hasMore: _propTypes.default.func.isRequired,
    loadMore: _propTypes.default.func.isRequired,
    isLoading: _propTypes.default.func.isRequired
  }).isRequired,
  pullRequest: _propTypes.default.shape({
    reviews: (0, _propTypes2.RelayConnectionPropType)(_propTypes.default.object)
  }),
  getBufferRowForDiffPosition: _propTypes.default.func.isRequired,
  isPatchVisible: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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