"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, this.props.token);

    if (this.props.search.isNull()) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishSearchContainerQuery.graphql");

      if (node.hash && node.hash !== "fc553ba742c51417ea1a857b96038345") {
        console.error("The definition of 'issueishSearchContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishSearchContainerQuery.graphql");
    });

    const variables = {
      query: this.props.search.createQuery(),
      first: this.props.limit
    };
    return _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    return _react.default.createElement(_issueishListController.default, _extends({
      total: props.search.issueCount,
      results: props.search.nodes,
      isLoading: false
    }, this.controllerProps()));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: this.props.search.getName(),
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenMore: () => this.props.onOpenSearch(this.props.search)
    };
  }

}

exports.default = IssueishSearchContainer;

_defineProperty(IssueishSearchContainer, "propTypes", {
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Search model
  limit: _propTypes.default.number,
  search: _propTypes2.SearchPropType.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  // Action methods
  onOpenIssueish: _propTypes.default.func.isRequired,
  onOpenSearch: _propTypes.default.func.isRequired
});

_defineProperty(IssueishSearchContainer, "defaultProps", {
  limit: 20
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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