/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import com.sun.tools.sjavac.Log;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.tools.JavaFileObject;

public class PathAndPackageVerifier
implements TaskListener {
    Set<CompilationUnitTree> misplacedCompilationUnits = new HashSet<CompilationUnitTree>();

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
            CompilationUnitTree compilationUnitTree = taskEvent.getCompilationUnit();
            if (compilationUnitTree == null) {
                return;
            }
            JavaFileObject object = compilationUnitTree.getSourceFile();
            if (object == null) {
                return;
            }
            JCTree jCTree = (JCTree)((Object)compilationUnitTree.getPackageName());
            if (jCTree == null) {
                return;
            }
            Path path = Paths.get(object.toUri()).normalize().getParent();
            if (!this.checkPathAndPackage(path, jCTree)) {
                this.misplacedCompilationUnits.add(compilationUnitTree);
            }
        }
        if (taskEvent.getKind() == TaskEvent.Kind.COMPILATION) {
            for (CompilationUnitTree compilationUnitTree : this.misplacedCompilationUnits) {
                Log.error("Misplaced compilation unit.");
                Log.error("    Directory: " + Paths.get(compilationUnitTree.getSourceFile().toUri()).getParent());
                Log.error("    Package:   " + compilationUnitTree.getPackageName());
            }
        }
    }

    public boolean errorsDiscovered() {
        return this.misplacedCompilationUnits.size() > 0;
    }

    private boolean checkPathAndPackage(Path path, JCTree jCTree) {
        ParentIterator parentIterator = new ParentIterator(path);
        EnclosingPkgIterator enclosingPkgIterator = new EnclosingPkgIterator(jCTree);
        while (parentIterator.hasNext() && enclosingPkgIterator.hasNext()) {
            if (((String)parentIterator.next()).equals(enclosingPkgIterator.next())) continue;
            return false;
        }
        return !enclosingPkgIterator.hasNext();
    }

    private static class EnclosingPkgIterator
    implements Iterator<String> {
        JCTree next;

        EnclosingPkgIterator(JCTree jCTree) {
            this.next = jCTree;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            Name name;
            if (this.next instanceof JCTree.JCIdent) {
                name = ((JCTree.JCIdent)this.next).name;
                this.next = null;
            } else {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)this.next;
                name = jCFieldAccess.name;
                this.next = jCFieldAccess.selected;
            }
            return name.toString();
        }
    }

    private static class ParentIterator
    implements Iterator<String> {
        Path next;

        ParentIterator(Path path) {
            this.next = path;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String string = this.next.getFileName().toString();
            this.next = this.next.getParent();
            return string;
        }
    }
}

