/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordParam;
import org.parosproxy.paros.db.TableParam;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableParam
extends ParosAbstractTable
implements TableParam {
    private static final String TABLE_NAME = "PARAM";
    private static final String PARAMID = "PARAMID";
    private static final String SITE = "SITE";
    private static final String TYPE = "TYPE";
    private static final String NAME = "NAME";
    private static final String USED = "USED";
    private static final String FLAGS = "FLAGS";
    private static final String VALUES = "VALS";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psUpdate = null;
    private PreparedStatement psGetAll = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.executeAndClose(conn.prepareStatement("CREATE cached TABLE PARAM (paramid bigint generated by default as identity (start with 1), site varchar(32768) not null, type varchar(32768) not null, name varchar(32768) not null, used int not null, flags varchar(32768) not null, vals varchar(8388608) not null)"));
            }
            this.psRead = conn.prepareStatement("SELECT * FROM PARAM WHERE PARAMID = ?");
            this.psInsert = conn.prepareStatement("INSERT INTO PARAM (SITE,TYPE,NAME,USED,FLAGS,VALS) VALUES (?, ?, ?, ?, ?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
            this.psUpdate = conn.prepareStatement("UPDATE PARAM SET USED = ?,FLAGS = ?,VALS = ? WHERE PARAMID = ?");
            this.psGetAll = conn.prepareStatement("SELECT * FROM PARAM");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordParam read(long urlId) throws DatabaseException {
        try {
            this.psRead.setLong(1, urlId);
            try (ResultSet rs = this.psRead.executeQuery();){
                RecordParam result;
                RecordParam recordParam = result = this.build(rs);
                return recordParam;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<RecordParam> getAll() throws DatabaseException {
        try {
            ArrayList<RecordParam> result = new ArrayList<RecordParam>();
            try (ResultSet rs = this.psGetAll.executeQuery();){
                while (rs.next()) {
                    result.add(new RecordParam(rs.getLong(PARAMID), rs.getString(SITE), rs.getString(TYPE), rs.getString(NAME), rs.getInt(USED), rs.getString(FLAGS), rs.getString(VALUES)));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordParam insert(String site, String type, String name, int used, String flags, String values) throws DatabaseException {
        try {
            long id;
            this.psInsert.setString(1, site);
            this.psInsert.setString(2, type);
            this.psInsert.setString(3, name);
            this.psInsert.setInt(4, used);
            this.psInsert.setString(5, flags);
            this.psInsert.setString(6, values);
            this.psInsert.executeUpdate();
            try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
                rs.next();
                id = rs.getLong(1);
            }
            return this.read(id);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void update(long paramId, int used, String flags, String values) throws DatabaseException {
        try {
            this.psUpdate.setInt(1, used);
            this.psUpdate.setString(2, flags);
            this.psUpdate.setString(3, values);
            this.psUpdate.setLong(4, paramId);
            this.psUpdate.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private RecordParam build(ResultSet rs) throws DatabaseException {
        try {
            RecordParam rt = null;
            if (rs.next()) {
                rt = new RecordParam(rs.getLong(PARAMID), rs.getString(SITE), rs.getString(TYPE), rs.getString(NAME), rs.getInt(USED), rs.getString(FLAGS), rs.getString(VALUES));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

