/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import hughai.PlayerObjects;
import hughai.utils.FileHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TdfParser {
    PlayerObjects playerObjects;
    public String rawtdf = "";
    String[] splitrawtdf;
    State currentstate;
    Section currentsection;
    public Section RootSection;
    int level;

    public TdfParser(PlayerObjects playerObjects, String string) {
        this.playerObjects = playerObjects;
        this.rawtdf = string;
        this.Parse();
    }

    void debug(Object object) {
    }

    public static TdfParser FromFile(PlayerObjects playerObjects, String string) {
        String string2 = new FileHelper(playerObjects).readFile(string);
        return new TdfParser(playerObjects, string2);
    }

    void GenerateSplitArray() {
        this.splitrawtdf = this.rawtdf.split("\n");
        for (int i = 0; i < this.splitrawtdf.length; ++i) {
            this.splitrawtdf[i] = this.splitrawtdf[i].trim();
        }
    }

    int ParseLine(int n, String string) {
        this.debug("ParseLine " + n + " " + string);
        switch (this.currentstate) {
            case NormalParse: {
                int n2;
                if (string.indexOf("[") == 0) {
                    this.currentstate = State.InSectionHeader;
                    String string2 = (string.substring(1) + "]").split("]")[0].toLowerCase();
                    Section section = new Section(string2);
                    section.Parent = this.currentsection;
                    if (!this.currentsection.SubSections.containsKey(string2)) {
                        this.currentsection.SubSections.put(string2, section);
                    }
                    this.debug("section header found: " + string2);
                    this.currentsection = section;
                    break;
                }
                if (string.indexOf("}") == 0) {
                    --this.level;
                    this.debug("section } found, new level:" + this.level);
                    if (this.currentsection.Parent == null) break;
                    this.currentsection = this.currentsection.Parent;
                    break;
                }
                if (string == "" || string.indexOf("//") == 0 || string.indexOf("/*") == 0 || (n2 = string.indexOf("=")) < 0) break;
                String string3 = string.substring(0, n2).toLowerCase();
                String string4 = string.substring(n2 + 1);
                string4 = (string4 + ";").split(";", -1)[0];
                this.debug("   value found [" + string3 + "] = [" + string4 + "]");
                if (this.currentsection.Values.containsKey(string3)) break;
                this.currentsection.Values.put(string3, string4);
                break;
            }
            case InSectionHeader: {
                if (string.indexOf("{") != 0) break;
                this.currentstate = State.NormalParse;
                ++this.level;
                this.debug("section { found, new level:" + this.level);
            }
        }
        return n;
    }

    void Parse() {
        this.GenerateSplitArray();
        this.RootSection = new Section();
        this.level = 0;
        this.currentsection = this.RootSection;
        this.currentstate = State.NormalParse;
        for (int i = 0; i < this.splitrawtdf.length; ++i) {
            i = this.ParseLine(i, this.splitrawtdf[i]);
        }
    }

    public class Section {
        public String Name;
        public Section Parent = null;
        public HashMap<String, Section> SubSections = new HashMap();
        public HashMap<String, String> Values = new HashMap();

        public Section SubSection(String string) {
            try {
                return this.GetSectionByPath(string);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Section() {
        }

        public Section(String string) {
            this.Name = string;
        }

        public double GetDoubleValue(String string) {
            return this.GetDoubleValue(0.0, string);
        }

        public int GetIntValue(String string) {
            return this.GetIntValue(0, string);
        }

        public String GetStringValue(String string) {
            return this.GetStringValue("", string);
        }

        public double[] GetDoubleArray(String string) {
            return this.GetDoubleArray(new double[0], string);
        }

        public double GetDoubleValue(double d, String string) {
            try {
                String string2 = this.GetValueByPath(string);
                return Double.parseDouble(string2);
            }
            catch (Exception exception) {
                return d;
            }
        }

        public int GetIntValue(int n, String string) {
            try {
                String string2 = this.GetValueByPath(string);
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return n;
            }
        }

        public String GetStringValue(String string, String string2) {
            try {
                return this.GetValueByPath(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return string;
            }
        }

        public double[] GetDoubleArray(double[] dArray, String string) {
            try {
                String string2 = this.GetValueByPath(string);
                String[] stringArray = string2.trim().split(" ");
                int n = stringArray.length;
                double[] dArray2 = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = Double.parseDouble(stringArray[i]);
                }
                return dArray2;
            }
            catch (Exception exception) {
                return dArray;
            }
        }

        List<String> GetPathParts(String string) {
            String[] stringArray = string.split("/");
            ArrayList<String> arrayList = new ArrayList<String>();
            TdfParser.this.debug("GetPathParts");
            for (String string2 : stringArray) {
                String[] stringArray2;
                TdfParser.this.debug("  subpath " + string2);
                for (String string3 : stringArray2 = string2.trim().split("\\\\")) {
                    TdfParser.this.debug("  subsubpath " + string3);
                    arrayList.add(string3.trim().toLowerCase());
                }
            }
            return arrayList;
        }

        Section GetSectionByPath(String string) {
            TdfParser.this.debug("GetSectionByPath " + string);
            List<String> list = this.GetPathParts(string);
            Section section = this;
            for (int i = 0; i < list.size(); ++i) {
                TdfParser.this.debug("   pathpart: " + list.get(i));
                section = section.SubSections.get(list.get(i));
            }
            return section;
        }

        String GetValueByPath(String string) {
            List<String> list = this.GetPathParts(string);
            Section section = this;
            for (int i = 0; i < list.size() - 1; ++i) {
                section = section.SubSections.get(list.get(i));
            }
            return section.Values.get(list.get(list.size() - 1));
        }
    }

    static enum State {
        InSectionHeader,
        NormalParse;

    }
}

