/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.split;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.RadioButton;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.split.SplitParametersBuilderCreator;
import org.pdfsam.support.params.SplitParametersBuilder;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.model.input.PdfSource;
import org.sejda.model.parameter.SplitByEveryXPagesParameters;

public class SplitByEveryRadioButton
extends RadioButton
implements SplitParametersBuilderCreator,
RestorableView {
    private final ValidableTextField field;

    public SplitByEveryRadioButton(ValidableTextField field) {
        super(DefaultI18nContext.getInstance().i18n("Split by every \"n\" pages"));
        this.field = field;
        this.field.setOnEnterValidation(true);
        this.field.setEnableInvalidStyle(true);
        this.field.setPromptText(DefaultI18nContext.getInstance().i18n("Number of pages"));
        this.field.setValidator(Validators.positiveInteger());
        this.field.setErrorMessage(DefaultI18nContext.getInstance().i18n("Invalid number of pages"));
    }

    public SplitByEveryXPagesParametersBuilder getBuilder(Consumer<String> onError) {
        this.field.validate();
        if (this.field.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            return new SplitByEveryXPagesParametersBuilder(Integer.parseInt(this.field.getText()));
        }
        onError.accept(DefaultI18nContext.getInstance().i18n("Invalid number of pages"));
        return null;
    }

    public void saveStateTo(Map<String, String> data) {
        if (this.isSelected()) {
            data.put("splitByEvery", Boolean.TRUE.toString());
        }
        data.put("splitByEvery.field", StringUtils.defaultString((String)this.field.getText()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("splitByEvery")).map(Boolean::valueOf).ifPresent(arg_0 -> ((SplitByEveryRadioButton)this).setSelected(arg_0));
        this.field.setText(Optional.ofNullable(data.get("splitByEvery.field")).orElse(""));
    }

    void setMaxPages(Integer value) {
        if (value > 1) {
            this.field.setValidator(Validators.positiveIntRange((int)1, (int)(value - 1)));
        }
    }

    static class SplitByEveryXPagesParametersBuilder
    extends SplitParametersBuilder<SplitByEveryXPagesParameters> {
        private int step;

        SplitByEveryXPagesParametersBuilder(int step) {
            this.step = step;
        }

        public SplitByEveryXPagesParameters build() {
            SplitByEveryXPagesParameters params = new SplitByEveryXPagesParameters(this.step);
            params.setCompress(this.isCompress());
            params.setExistingOutputPolicy(this.existingOutput());
            params.setVersion(this.getVersion());
            params.setOutput(this.getOutput());
            params.setOutputPrefix(this.getPrefix());
            params.addSource((PdfSource)this.getSource());
            params.setOptimizationPolicy(this.getOptimizationPolicy());
            params.discardOutline(this.isDiscardBookmarks());
            return params;
        }
    }
}

