/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.sourcemap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.common.sourcemap.SourceMap;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.netbeans.spi.project.DependencyProjectProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public final class SourceMapsScanner {
    private static final Logger LOG = Logger.getLogger(SourceMapsScanner.class.getName());
    private static final String SRC_MAP_EXT = "map";
    private static final SourceMapsScanner INSTANCE = new SourceMapsScanner();
    private final Map<Project, ProjectSourceMapsScanner> projectsMaps = new WeakHashMap<Project, ProjectSourceMapsScanner>();

    private SourceMapsScanner() {
    }

    public static SourceMapsScanner getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceMapsTranslator scan(Project p) {
        ProjectSourceMapsScanner ps;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("scan(" + p + "), proj. dir = " + p.getProjectDirectory());
        }
        boolean isNew = false;
        Map<Project, ProjectSourceMapsScanner> map = this.projectsMaps;
        synchronized (map) {
            ps = this.projectsMaps.get(p);
            if (ps == null) {
                ps = new ProjectSourceMapsScanner();
                this.projectsMaps.put(p, ps);
                isNew = true;
            }
        }
        if (isNew) {
            ps.init(p);
        }
        ps.waitScanned();
        return ps.getSourceMapTranslator();
    }

    public SourceMapsTranslator scan(FileObject[] roots) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("scan(" + Arrays.toString(roots) + ")");
        }
        ProjectSourceMapsScanner ps = new ProjectSourceMapsScanner();
        ps.init(roots);
        ps.waitScanned();
        return ps.getSourceMapTranslator();
    }

    private static final class ProjectSourceMapsScanner
    implements ChangeListener,
    FileChangeListener,
    Runnable {
        private static final RequestProcessor RP = new RequestProcessor(ProjectSourceMapsScanner.class);
        private final SourceMapsTranslator smt;
        private FileObject[] roots;
        private final Object rootsLock = new Object();
        private final Set<FileObject> rootsToScan = new HashSet<FileObject>();
        private final Map<FileObject, SourceMap> sourceMaps = new HashMap<FileObject, SourceMap>();
        private RequestProcessor.Task scanningTask;
        private final Object scanningTaskLock = new Object();
        private ProjectDependencyManager projectDependencyManager;

        ProjectSourceMapsScanner() {
            this.smt = new SourceMapsTranslatorDelegate(SourceMapsTranslator.create());
        }

        SourceMapsTranslator getSourceMapTranslator() {
            return this.smt;
        }

        void init(Project p) {
            Sources sources = ProjectUtils.getSources((Project)p);
            sources.addChangeListener((ChangeListener)this);
            SourceGroup[] groups = sources.getSourceGroups("generic");
            this.roots = new FileObject[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                FileObject rootFolder;
                SourceGroup group = groups[i];
                this.roots[i] = rootFolder = group.getRootFolder();
                rootFolder.addRecursiveListener((FileChangeListener)this);
                this.rootsToScan.add(rootFolder);
            }
            this.scanningTask = RP.post((Runnable)this);
            DependencyProjectProvider prov = (DependencyProjectProvider)p.getLookup().lookup(DependencyProjectProvider.class);
            if (prov != null) {
                this.projectDependencyManager = new ProjectDependencyManager(prov);
            }
        }

        void init(FileObject[] roots) {
            this.roots = roots;
            for (int i = 0; i < roots.length; ++i) {
                roots[i].addRecursiveListener((FileChangeListener)this);
                this.rootsToScan.add(roots[i]);
            }
            this.scanningTask = RP.post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitScanned() {
            Object object = this.scanningTaskLock;
            synchronized (object) {
                if (this.scanningTask != null) {
                    this.scanningTask.waitFinished();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileObject[] fileObjectArray = this.rootsToScan;
            synchronized (this.rootsToScan) {
                FileObject[] roots = this.rootsToScan.toArray(new FileObject[this.rootsToScan.size()]);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (FileObject root : roots) {
                    this.scan(root);
                }
                return;
            }
        }

        private void scan(FileObject root) {
            LOG.log(Level.FINE, "Scanning folder {0}", root);
            Enumeration children = root.getChildren(true);
            while (children.hasMoreElements()) {
                FileObject fo = (FileObject)children.nextElement();
                this.registerIfSourceMap(fo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerIfSourceMap(FileObject fo) {
            SourceMap sm;
            if (!(fo.isValid() && fo.isData() && fo.getExt().equalsIgnoreCase(SourceMapsScanner.SRC_MAP_EXT) && fo.canRead())) {
                return;
            }
            LOG.log(Level.FINE, "  found source map (?) {0}", fo);
            try {
                sm = SourceMap.parse(fo.asText("UTF-8"));
            }
            catch (IOException | IllegalArgumentException ex) {
                return;
            }
            String compiledFile = sm.getFile();
            FileObject compiledFO = compiledFile == null ? ProjectSourceMapsScanner.findCompiledFile(fo) : fo.getParent().getFileObject(compiledFile);
            LOG.log(Level.FINE, "  have source map for generated file {0}", compiledFO);
            if (compiledFO != null) {
                Map<FileObject, SourceMap> map = this.sourceMaps;
                synchronized (map) {
                    this.sourceMaps.put(fo, sm);
                }
                this.smt.registerTranslation(compiledFO, sm);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterSourceMap(FileObject fo) {
            SourceMap sm;
            Map<FileObject, SourceMap> map = this.sourceMaps;
            synchronized (map) {
                sm = this.sourceMaps.remove(fo);
            }
            if (sm != null) {
                String compiledFile = sm.getFile();
                FileObject compiledFO = compiledFile == null ? ProjectSourceMapsScanner.findCompiledFile(fo) : fo.getParent().getFileObject(compiledFile);
                this.smt.unregisterTranslation(compiledFO);
            }
        }

        private static FileObject findCompiledFile(FileObject sourceMapFile) {
            String name = sourceMapFile.getName();
            FileObject parent = sourceMapFile.getParent();
            FileObject compiledFO = parent.getFileObject(name);
            if (compiledFO != null) {
                return compiledFO;
            }
            compiledFO = parent.getFileObject(name, "js");
            if (compiledFO != null) {
                return compiledFO;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            ArrayList<FileObject> removedRoots;
            Sources sources = (Sources)e.getSource();
            SourceGroup[] groups = sources.getSourceGroups("generic");
            FileObject[] roots2 = new FileObject[groups.length];
            ArrayList<FileObject> newRoots = new ArrayList<FileObject>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                FileObject rootFolder;
                SourceGroup group = groups[i];
                roots2[i] = rootFolder = group.getRootFolder();
                newRoots.add(rootFolder);
            }
            Object i = this.rootsLock;
            synchronized (i) {
                removedRoots = new ArrayList<FileObject>(this.roots.length);
                for (FileObject r : this.roots) {
                    if (newRoots.remove(r)) continue;
                    removedRoots.add(r);
                }
                this.roots = roots2;
            }
            if (!removedRoots.isEmpty()) {
                ArrayList<FileObject> removedSourceMaps = new ArrayList<FileObject>();
                Map<FileObject, SourceMap> map = this.sourceMaps;
                synchronized (map) {
                    block11: for (FileObject fo : this.sourceMaps.keySet()) {
                        for (FileObject rr : removedRoots) {
                            if (!FileUtil.isParentOf((FileObject)rr, (FileObject)fo)) continue;
                            removedSourceMaps.add(fo);
                            continue block11;
                        }
                    }
                    this.sourceMaps.keySet().removeAll(removedSourceMaps);
                }
                for (FileObject fo : removedSourceMaps) {
                    this.unregisterSourceMap(fo);
                }
            }
            Set<FileObject> set = this.rootsToScan;
            synchronized (set) {
                this.rootsToScan.addAll(newRoots);
            }
            this.scanningTask = RP.post((Runnable)this);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            this.registerIfSourceMap(fe.getFile());
        }

        public void fileChanged(FileEvent fe) {
            FileObject fo = fe.getFile();
            this.unregisterSourceMap(fo);
            this.registerIfSourceMap(fo);
        }

        public void fileDeleted(FileEvent fe) {
            FileObject fo = fe.getFile();
            this.unregisterSourceMap(fo);
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private class ProjectDependencyManager
        implements ChangeListener {
            public ProjectDependencyManager(DependencyProjectProvider prov) {
                prov.addChangeListener((ChangeListener)this);
                this.init(prov);
            }

            private void init(DependencyProjectProvider prov) {
                DependencyProjectProvider.Result res = prov.getDependencyProjects();
                Set projects = res.getProjects();
                SourceMapsTranslatorDelegate smtd = (SourceMapsTranslatorDelegate)ProjectSourceMapsScanner.this.smt;
                smtd.removeAllButTheFirst();
                if (!projects.isEmpty()) {
                    for (Project p : projects) {
                        SourceMapsTranslator psmt = INSTANCE.scan(p);
                        smtd.add(psmt);
                    }
                }
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                DependencyProjectProvider prov = (DependencyProjectProvider)e.getSource();
                this.init(prov);
            }
        }

        private static class SourceMapsTranslatorDelegate
        implements SourceMapsTranslator {
            private final SourceMapsTranslator mainSmt;
            private final List<SourceMapsTranslator> delegates = new CopyOnWriteArrayList<SourceMapsTranslator>();

            public SourceMapsTranslatorDelegate(SourceMapsTranslator smt) {
                this.mainSmt = smt;
                this.delegates.add(smt);
            }

            void add(SourceMapsTranslator smt) {
                this.delegates.add(smt);
            }

            void remove(SourceMapsTranslator smt) {
                this.delegates.remove(smt);
            }

            void removeAllButTheFirst() {
                this.delegates.retainAll(this.delegates.subList(0, 1));
            }

            @Override
            public boolean registerTranslation(FileObject source, String sourceMapFileName) {
                return this.mainSmt.registerTranslation(source, sourceMapFileName);
            }

            @Override
            public boolean registerTranslation(FileObject source, SourceMap sourceMap) {
                return this.mainSmt.registerTranslation(source, sourceMap);
            }

            @Override
            public void unregisterTranslation(FileObject source) {
                this.mainSmt.unregisterTranslation(source);
            }

            @Override
            public SourceMapsTranslator.Location getSourceLocation(SourceMapsTranslator.Location loc) {
                for (SourceMapsTranslator smt : this.delegates) {
                    SourceMapsTranslator.Location l = smt.getSourceLocation(loc);
                    if (l == loc) continue;
                    return l;
                }
                return loc;
            }

            @Override
            public SourceMapsTranslator.Location getSourceLocation(SourceMapsTranslator.Location loc, String sourceMapFileName) {
                for (SourceMapsTranslator smt : this.delegates) {
                    SourceMapsTranslator.Location l = smt.getSourceLocation(loc, sourceMapFileName);
                    if (l == loc) continue;
                    return l;
                }
                return loc;
            }

            @Override
            public SourceMapsTranslator.Location getCompiledLocation(SourceMapsTranslator.Location loc) {
                for (SourceMapsTranslator smt : this.delegates) {
                    SourceMapsTranslator.Location l = smt.getCompiledLocation(loc);
                    if (l == loc) continue;
                    return l;
                }
                return loc;
            }

            @Override
            public List<FileObject> getSourceFiles(FileObject compiledFile) {
                for (SourceMapsTranslator smt : this.delegates) {
                    List<FileObject> sourceFiles = smt.getSourceFiles(compiledFile);
                    if (sourceFiles == null) continue;
                    return sourceFiles;
                }
                return null;
            }
        }
    }
}

