/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.modules.editor.search.ListFocusTraversalPolicy;
import org.netbeans.modules.editor.search.SearchBar;
import org.netbeans.modules.editor.search.SearchButton;
import org.netbeans.modules.editor.search.SearchComboBox;
import org.netbeans.modules.editor.search.SearchComboBoxEditor;
import org.netbeans.modules.editor.search.SearchPropertiesSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class ReplaceBar
extends JPanel
implements PropertyChangeListener {
    private static ReplaceBar replacebarInstance = null;
    private static final Logger LOG = Logger.getLogger(ReplaceBar.class.getName());
    private SearchBar searchBar;
    private final JComboBox<String> replaceComboBox;
    private final JTextComponent replaceTextField;
    private final JButton replaceButton;
    private final JButton replaceAllButton;
    private final JLabel replaceLabel;
    private final JCheckBox preserveCaseCheckBox;
    private final JCheckBox backwardsCheckBox;
    private final FocusTraversalPolicy searchBarFocusTraversalPolicy;
    private final List<Component> focusList = new ArrayList<Component>();
    private boolean popupMenuWasCanceled = false;
    private ActionListener closeButtonListener;

    public static ReplaceBar getInstance(SearchBar searchBar) {
        if (replacebarInstance == null) {
            replacebarInstance = new ReplaceBar(searchBar);
        }
        if (replacebarInstance.getSearchBar() != searchBar) {
            replacebarInstance.setSearchBar(searchBar);
        }
        return replacebarInstance;
    }

    private ReplaceBar(SearchBar searchBar) {
        this.setSearchBar(searchBar);
        this.addEscapeKeystrokeFocusBackTo(this);
        this.setLayout(new BoxLayout(this, 2));
        this.setFocusCycleRoot(true);
        this.setForeground(UIManager.getColor("textText"));
        this.add(Box.createHorizontalStrut(8));
        SearchComboBox<String> scb = new SearchComboBox<String>();
        this.replaceComboBox = scb;
        this.replaceComboBox.addPopupMenuListener(new ReplacePopupMenuListener());
        this.replaceTextField = scb.getEditorPane();
        this.replaceTextField.setToolTipText(NbBundle.getMessage(ReplaceBar.class, (String)"TOOLTIP_ReplaceText"));
        this.replaceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ReplaceBar.this.getSearchBar().lostFocusOnTextField();
            }
        });
        this.addEnterKeystrokeReplaceTo(this.replaceTextField);
        this.addShiftEnterReplaceAllTo(this.replaceTextField);
        this.replaceLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.replaceLabel, (String)NbBundle.getMessage(ReplaceBar.class, (String)"CTL_Replace"));
        this.replaceLabel.setLabelFor(this.replaceTextField);
        this.add(this.replaceLabel);
        this.add(this.replaceComboBox);
        JToolBar.Separator leftSeparator = new JToolBar.Separator();
        leftSeparator.setOrientation(1);
        this.add(leftSeparator);
        this.replaceButton = SearchButton.createButton("org/netbeans/modules/editor/search/resources/replace.png", "CTL_ReplaceNext");
        this.replaceButton.setToolTipText(NbBundle.getMessage(ReplaceBar.class, (String)"TOOLTIP_ReplaceText"));
        this.replaceButton.setEnabled(!this.getSearchBar().getIncSearchTextField().getText().isEmpty());
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.replace();
            }
        });
        this.add(this.replaceButton);
        this.replaceAllButton = SearchButton.createButton("org/netbeans/modules/editor/search/resources/replace_all.png", "CTL_ReplaceAll");
        this.replaceAllButton.setToolTipText(NbBundle.getMessage(ReplaceBar.class, (String)"TOOLTIP_ReplaceText"));
        this.replaceAllButton.setEnabled(!this.getSearchBar().getIncSearchTextField().getText().isEmpty());
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.replaceAll();
            }
        });
        this.add(this.replaceAllButton);
        this.changeButtonsSizeAsSearchBarButtons();
        searchBar.addCheckBoxesActions(this.replaceTextField);
        JToolBar.Separator rightSeparator = new JToolBar.Separator();
        rightSeparator.setOrientation(1);
        this.add(rightSeparator);
        this.backwardsCheckBox = searchBar.createCheckBox("CTL_BackwardsReplace", "find-backward-search");
        this.add(this.backwardsCheckBox);
        this.preserveCaseCheckBox = searchBar.createCheckBox("CTL_PreserveCase", "find-preserve-case");
        this.preserveCaseCheckBox.setToolTipText(NbBundle.getMessage(ReplaceBar.class, (String)"TOOLTIP_PreserveCase"));
        this.add(this.preserveCaseCheckBox);
        this.backwardsCheckBox.setSelected(searchBar.getFindSupportValue("find-backward-search"));
        this.preserveCaseCheckBox.setSelected(searchBar.getFindSupportValue("find-preserve-case"));
        this.preserveCaseCheckBox.setEnabled(!searchBar.getRegExp() && !searchBar.getFindSupportValue("find-match-case"));
        this.add(Box.createHorizontalGlue());
        this.focusList.clear();
        this.focusList.add(searchBar.getIncSearchTextField());
        this.focusList.add(this.replaceTextField);
        this.searchBarFocusTraversalPolicy = new ListFocusTraversalPolicy(this.focusList);
        EditorFindSupport.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorFindSupport.getInstance()));
        this.setVisible(false);
    }

    private SearchBar getSearchBar() {
        return this.searchBar;
    }

    private void setSearchBar(SearchBar searchBar) {
        this.searchBar = searchBar;
    }

    public JButton getReplaceButton() {
        return this.replaceButton;
    }

    public JButton getReplaceAllButton() {
        return this.replaceAllButton;
    }

    public JTextComponent getReplaceTextField() {
        return this.replaceTextField;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    private void changeButtonsSizeAsSearchBarButtons() {
        int diffEven;
        int searchBarButtonsSize = this.searchBar.getFindNextButton().getPreferredSize().width + this.searchBar.getFindPreviousButton().getPreferredSize().width;
        int replaceBarButtonsSize = this.replaceButton.getPreferredSize().width + this.replaceAllButton.getPreferredSize().width;
        int diffButtonsSize = (searchBarButtonsSize - replaceBarButtonsSize) / 2;
        int n = diffEven = diffButtonsSize % 2 == 0 ? 0 : 1;
        if (diffButtonsSize > 0) {
            this.replaceButton.setPreferredSize(new Dimension(this.replaceButton.getPreferredSize().width + diffButtonsSize + diffEven, this.replaceButton.getPreferredSize().height));
            this.replaceAllButton.setPreferredSize(new Dimension(this.replaceAllButton.getPreferredSize().width + diffButtonsSize, this.replaceAllButton.getPreferredSize().height));
        } else {
            this.searchBar.getFindNextButton().setPreferredSize(new Dimension(this.searchBar.getFindNextButton().getPreferredSize().width - diffButtonsSize + diffEven, this.searchBar.getFindNextButton().getPreferredSize().height));
            this.searchBar.getFindPreviousButton().setPreferredSize(new Dimension(this.searchBar.getFindPreviousButton().getPreferredSize().width - diffButtonsSize, this.searchBar.getFindPreviousButton().getPreferredSize().height));
        }
    }

    private void addEnterKeystrokeReplaceTo(JTextComponent replaceTextField) {
        replaceTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "replace-next");
        replaceTextField.getActionMap().put("replace-next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ReplaceBar.this.popupMenuWasCanceled && !ReplaceBar.this.searchBar.isPopupMenuWasCanceled()) {
                    ReplaceBar.this.replace();
                } else {
                    ReplaceBar.this.popupMenuWasCanceled = false;
                    ReplaceBar.this.searchBar.setPopupMenuWasCanceled(false);
                }
            }
        });
    }

    private void addShiftEnterReplaceAllTo(JTextComponent textField) {
        textField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "replace-all");
        textField.getActionMap().put("replace-all", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.replaceAll();
            }
        });
    }

    private void addEscapeKeystrokeFocusBackTo(JPanel jpanel) {
        jpanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        jpanel.getActionMap().put("loose-focus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ReplaceBar.this.popupMenuWasCanceled && !ReplaceBar.this.searchBar.isPopupMenuWasCanceled()) {
                    ReplaceBar.this.looseFocus();
                } else {
                    ReplaceBar.this.popupMenuWasCanceled = false;
                    ReplaceBar.this.searchBar.setPopupMenuWasCanceled(false);
                }
            }
        });
    }

    void updateReplaceComboBoxHistory(String incrementalSearchText) {
        EditorFindSupport.getInstance().addToReplaceHistory(new EditorFindSupport.RP(incrementalSearchText, this.preserveCaseCheckBox.isSelected()));
        for (int i = this.replaceComboBox.getItemCount() - 1; i >= 0; --i) {
            String item = this.replaceComboBox.getItemAt(i);
            if (!item.equals(incrementalSearchText)) continue;
            this.replaceComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.replaceComboBox.getModel()).insertElementAt(incrementalSearchText, 0);
        this.replaceComboBox.setSelectedIndex(0);
    }

    private ActionListener getCloseButtonListener() {
        if (this.closeButtonListener == null) {
            this.closeButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReplaceBar.this.looseFocus();
                }
            };
        }
        return this.closeButtonListener;
    }

    private void unchangeSearchBarToBeOnlySearchBar() {
        this.searchBar.getCloseButton().removeActionListener(this.getCloseButtonListener());
        Mnemonics.setLocalizedText((JLabel)this.searchBar.getFindLabel(), (String)NbBundle.getMessage(ReplaceBar.class, (String)"CTL_Find"));
        Dimension oldDimensionForFindLabel = this.searchBar.getFindLabel().getUI().getMinimumSize(this.searchBar.getFindLabel());
        this.searchBar.getFindLabel().setMinimumSize(oldDimensionForFindLabel);
        this.searchBar.getFindLabel().setPreferredSize(oldDimensionForFindLabel);
        this.searchBar.addEscapeKeystrokeFocusBackTo(this.searchBar);
        this.searchBar.setFocusTraversalPolicy(null);
        this.searchBar.looseFocus();
        this.searchBar.setSearchProperties(SearchPropertiesSupport.getSearchProperties());
    }

    private void changeSearchBarToBePartOfReplaceBar() {
        this.searchBar.getCloseButton().addActionListener(this.getCloseButtonListener());
        Mnemonics.setLocalizedText((JLabel)this.searchBar.getFindLabel(), (String)NbBundle.getMessage(ReplaceBar.class, (String)"CTL_Replace_Find"));
        Dimension newDimensionForFindLabel = new Dimension(this.replaceLabel.getPreferredSize().width, this.searchBar.getFindLabel().getPreferredSize().height);
        this.searchBar.getFindLabel().setMinimumSize(newDimensionForFindLabel);
        this.searchBar.getFindLabel().setPreferredSize(newDimensionForFindLabel);
        this.addEscapeKeystrokeFocusBackTo(this.searchBar);
        this.searchBar.setFocusTraversalPolicy(this.searchBarFocusTraversalPolicy);
        this.setFocusTraversalPolicy(this.searchBarFocusTraversalPolicy);
        this.searchBar.getPreferredSize();
        this.searchBar.setSearchProperties(SearchPropertiesSupport.getReplaceProperties());
    }

    public void looseFocus() {
        if (!this.isVisible()) {
            return;
        }
        this.unchangeSearchBarToBeOnlySearchBar();
        this.setVisible(false);
    }

    public void gainFocus(boolean persistanceStatus) {
        if (!this.isVisible()) {
            String lastReplace = this.replaceTextField.getText();
            this.changeSearchBarToBePartOfReplaceBar();
            SearchComboBoxEditor.changeToOneLineEditorPane((JEditorPane)this.replaceTextField);
            this.addEnterKeystrokeReplaceTo(this.replaceTextField);
            MutableComboBoxModel comboBoxModelIncSearch = (MutableComboBoxModel)this.replaceComboBox.getModel();
            for (int i = comboBoxModelIncSearch.getSize() - 1; i >= 0; --i) {
                comboBoxModelIncSearch.removeElementAt(i);
            }
            for (EditorFindSupport.RP rp : EditorFindSupport.getInstance().getReplaceHistory()) {
                comboBoxModelIncSearch.addElement(rp.getReplaceExpression());
            }
            this.replaceTextField.setText(lastReplace);
            this.setVisible(true);
        }
        this.searchBar.gainFocus(persistanceStatus);
        this.searchBar.getIncSearchTextField().requestFocusInWindow();
    }

    private void replace() {
        this.replace(false);
    }

    private void replaceAll() {
        this.replace(true);
    }

    private void replace(boolean replaceAll) {
        this.searchBar.updateIncSearchComboBoxHistory(this.searchBar.getIncSearchTextField().getText());
        this.updateReplaceComboBoxHistory(this.replaceTextField.getText());
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        HashMap<String, Object> findProps = new HashMap<String, Object>();
        findProps.putAll(this.searchBar.getSearchProperties());
        findProps.put("find-replace-with", this.replaceTextField.getText());
        findProps.put("find-backward-search", this.backwardsCheckBox.isSelected());
        findProps.put("find-preserve-case", this.preserveCaseCheckBox.isSelected() && this.preserveCaseCheckBox.isEnabled());
        findSupport.putFindProperties(findProps);
        if (replaceAll) {
            findSupport.replaceAll(findProps);
        } else {
            try {
                findSupport.replace(findProps, false);
                findSupport.find(findProps, false);
            }
            catch (GuardedException ge) {
                LOG.log(Level.FINE, null, ge);
                Toolkit.getDefaultToolkit().beep();
            }
            catch (BadLocationException ble) {
                LOG.log(Level.WARNING, null, ble);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isShowing()) {
            this.preserveCaseCheckBox.setEnabled((Boolean)EditorFindSupport.getInstance().getFindProperty("find-reg-exp") == false && (Boolean)EditorFindSupport.getInstance().getFindProperty("find-match-case") == false);
        }
    }

    private class ReplacePopupMenuListener
    implements PopupMenuListener {
        private ReplacePopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            ReplaceBar.this.popupMenuWasCanceled = true;
        }
    }
}

