/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.io.IOException;
import java.util.Arrays;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.loaders.DataObject;

public abstract class ResourceHolder {
    protected DataObject resource;
    protected final Class[] resourceClasses;

    public ResourceHolder(Class[] resourceClasses) {
        if (resourceClasses == null || resourceClasses.length == 0) {
            throw new IllegalArgumentException();
        }
        this.resourceClasses = resourceClasses;
    }

    public void setResource(DataObject resource) {
        if (resource == null) {
            this.resource = null;
            return;
        }
        Class<?> clazz = resource.getClass();
        if (!Arrays.asList(this.resourceClasses).contains(clazz)) {
            throw new IllegalArgumentException();
        }
        if (!resource.equals(this.resource)) {
            this.resource = resource;
        }
    }

    public DataObject getResource() {
        return this.resource;
    }

    public Class[] getResourceClasses() {
        return this.resourceClasses;
    }

    public abstract String[] getAllKeys();

    public abstract String getValueForKey(String var1);

    public abstract String getCommentForKey(String var1);

    public void addProperty(Object key, Object value, String comment) {
        boolean overwriteValues = I18nUtil.getOptions().isReplaceResourceValue();
        this.addProperty(key, value, comment, overwriteValues);
    }

    public abstract void addProperty(Object var1, Object var2, String var3, boolean var4);

    public final DataObject getTemplate(Class clazz) throws IOException {
        if (!Arrays.asList(this.resourceClasses).contains(clazz)) {
            throw new IllegalArgumentException();
        }
        return this.createTemplate(clazz);
    }

    protected abstract DataObject createTemplate(Class var1) throws IOException;

    public String toString() {
        return super.toString() + "[resource=" + String.valueOf(this.resource) + ", resourceClasses=" + Arrays.toString(this.resourceClasses) + ']';
    }
}

