/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileSelector
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    private static final String PROPERTIES_EXT = ".properties";
    private static final String DEFAULT_BUNDLE_NAME = "Bundle";
    private DataObject template;
    private ExplorerManager manager;
    private DataObject selectedDataObject;
    private DataFolder selectedFolder;
    private boolean confirmed;
    private JButton newButton;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField fileNameTextField;

    public FileSelector(FileObject fileInProject, DataObject template) {
        this(fileInProject, template, null);
    }

    public FileSelector(FileObject fileInProject, DataObject template, FileObject preselectedFile) {
        this(SelectorUtils.bundlesNode(null, fileInProject, template == null), template);
        if (preselectedFile != null) {
            this.preselectFile(preselectedFile);
        } else {
            this.preselectDefaultBundle(fileInProject);
        }
    }

    public void preselectFile(FileObject fo) {
        Node[] roots;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            return;
        }
        String packagePath = cp.getResourceName(fo.getParent()) + "/" + fo.getName();
        String[] packagePathArr = packagePath.split("/");
        for (Node possibleRoot : roots = this.manager.getRootContext().getChildren().getNodes()) {
            try {
                Node foundNode = NodeOp.findPath((Node)possibleRoot, (String[])packagePathArr);
                if (foundNode == null) continue;
                this.manager.setSelectedNodes(new Node[]{foundNode});
                break;
            }
            catch (NodeNotFoundException nodeNotFoundException) {
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void preselectDefaultBundle(FileObject fo) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            return;
        }
        String packageName = cp.getResourceName(fo.getParent());
        Node root = this.manager.getRootContext();
        List path = new ArrayList<String>();
        for (FileObject fo2 : cp.getRoots()) {
            if (!FileUtil.isParentOf((FileObject)fo2, (FileObject)fo)) continue;
            path.add(fo2.getName());
            break;
        }
        assert (path.size() == 1);
        path.addAll(Arrays.asList(packageName.split("/")));
        path.add(DEFAULT_BUNDLE_NAME);
        try {
            this.manager.setSelectedNodes(new Node[]{NodeOp.findPath((Node)root, (String[])path.toArray(new String[path.size()]))});
            return;
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NodeNotFoundException ex) {
            // empty catch block
        }
        path = path.subList(0, path.size() - 1);
        try {
            Node found = NodeOp.findPath((Node)root, (String[])path.toArray(new String[path.size()]));
            this.manager.setExploredContext(found);
            this.manager.setSelectedNodes(new Node[]{found});
            return;
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NodeNotFoundException ex) {
            // empty catch block
        }
        try {
            this.manager.setSelectedNodes(new Node[]{root});
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private FileSelector(Node root, DataObject template) {
        this.template = template;
        this.manager = new ExplorerManager();
        this.manager.setRootContext(root);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        if (template != null) {
            this.newButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)FileSelector.getLocMessage("CTL_CreateNewButton"));
            this.newButton.getAccessibleContext().setAccessibleName(FileSelector.getLocMessage("ACSN_CreateNewBundle"));
            this.newButton.getAccessibleContext().setAccessibleDescription(FileSelector.getLocMessage("ACSD_CreateNewBundle"));
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    block9: {
                        if (FileSelector.this.selectedFolder == null) {
                            return;
                        }
                        String fileName = FileSelector.this.fileNameTextField.getText();
                        try {
                            if (fileName.equals("")) {
                                fileName = FileSelector.DEFAULT_BUNDLE_NAME;
                            } else if (fileName.toLowerCase().endsWith(FileSelector.PROPERTIES_EXT)) {
                                fileName = fileName.substring(0, fileName.length() - FileSelector.PROPERTIES_EXT.length());
                            }
                            FileSelector.this.selectedDataObject = FileSelector.this.template.createFromTemplate(FileSelector.this.selectedFolder, fileName);
                            Node[] selected = FileSelector.this.manager.getSelectedNodes();
                            if (selected != null && selected.length == 1 && selected[0].getCookie(DataObject.class) == FileSelector.this.selectedFolder) {
                                Node[] sub = selected[0].getChildren().getNodes(true);
                                for (int i = 0; i < sub.length; ++i) {
                                    if (sub[i].getCookie(DataObject.class) != FileSelector.this.selectedDataObject) continue;
                                    FileSelector.this.manager.setSelectedNodes(new Node[]{sub[i]});
                                    break block9;
                                }
                                break block9;
                            }
                            if (selected == null || selected.length != 1 || ((DataObject)selected[0].getCookie(DataObject.class)).getFolder() != FileSelector.this.selectedFolder) break block9;
                            Node[] sub = selected[0].getParentNode().getChildren().getNodes(true);
                            for (int i = 0; i < sub.length; ++i) {
                                if (sub[i].getCookie(DataObject.class) != FileSelector.this.selectedDataObject) continue;
                                FileSelector.this.manager.setSelectedNodes(new Node[]{sub[i]});
                                break;
                            }
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            });
            this.newButton.setEnabled(false);
        }
        this.okButton = new JButton(NbBundle.getMessage(FileSelector.class, (String)"CTL_OKButton"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FileSelector.this.confirmed = true;
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(FileSelector.getLocMessage("CTL_CancelButton"));
        this.cancelButton.getAccessibleContext().setAccessibleName(FileSelector.getLocMessage("ACSN_CancelSelection"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(FileSelector.getLocMessage("ACSD_CancelSelection"));
        BeanTreeView treeView = new BeanTreeView();
        treeView.setPopupAllowed(false);
        treeView.setDefaultActionAllowed(false);
        treeView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSelector.class, (String)"ACSN_FileSelectorTreeView"));
        treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"ACSD_FileSelectorPanel"));
        JLabel treeViewLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)treeViewLabel, (String)FileSelector.getLocMessage("LBL_ExistingBundles"));
        treeViewLabel.setLabelFor(treeView.getViewport());
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)FileSelector.getLocMessage("LBL_FileName"));
        label.getAccessibleContext().setAccessibleName(FileSelector.getLocMessage("ACSN_FileName"));
        label.getAccessibleContext().setAccessibleDescription(FileSelector.getLocMessage("ACSD_FileName"));
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileSelector.this.checkFileName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileSelector.this.checkFileName();
            }
        });
        label.setLabelFor(this.fileNameTextField);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(treeViewLabel).addComponent((Component)treeView, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(label).addComponent(this.fileNameTextField)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(treeViewLabel).addComponent((Component)treeView, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.fileNameTextField)));
    }

    private static String getLocMessage(String bundleKey) {
        return NbBundle.getMessage(FileSelector.class, (String)bundleKey);
    }

    public Dialog getDialog(String title, ActionListener listener) {
        Object[] objectArray;
        if (this.newButton != null) {
            JButton[] jButtonArray = new JButton[3];
            jButtonArray[0] = this.newButton;
            jButtonArray[1] = this.okButton;
            objectArray = jButtonArray;
            jButtonArray[2] = this.cancelButton;
        } else {
            Object[] objectArray2 = new JButton[2];
            objectArray2[0] = this.okButton;
            objectArray = objectArray2;
            objectArray2[1] = this.cancelButton;
        }
        DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, objectArray, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, null);
        dd.setClosingOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
        if (listener != null) {
            this.okButton.addActionListener(listener);
        }
        return DialogDisplayer.getDefault().createDialog(dd);
    }

    @Override
    public void addNotify() {
        this.confirmed = false;
        super.addNotify();
    }

    boolean isConfirmed() {
        return this.confirmed;
    }

    public DataObject getSelectedDataObject() {
        return this.selectedDataObject;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("selectedNodes")) {
            DataObject dobj;
            Node[] nodes = this.manager.getSelectedNodes();
            this.selectedDataObject = null;
            this.selectedFolder = null;
            if (nodes != null && nodes.length == 1 && (dobj = (DataObject)nodes[0].getCookie(DataObject.class)) != null) {
                if (dobj instanceof PropertiesDataObject) {
                    this.fileNameTextField.setText(dobj.getName());
                    this.selectedDataObject = dobj;
                    this.selectedFolder = dobj.getFolder();
                } else if (dobj instanceof DataFolder) {
                    this.fileNameTextField.setText("");
                    this.selectedFolder = (DataFolder)dobj;
                } else {
                    this.selectedFolder = dobj.getFolder();
                }
            }
            this.okButton.setEnabled(this.selectedDataObject != null);
            if (this.newButton != null) {
                this.newButton.setEnabled(this.selectedFolder != null && this.selectedDataObject == null && !this.checkForDefaultBundle());
            }
        }
    }

    private boolean checkForDefaultBundle() {
        if (this.selectedFolder != null) {
            return this.selectedFolder.getPrimaryFile().getFileObject("Bundle.properties") != null;
        }
        return false;
    }

    private void checkFileName() {
        if (this.selectedFolder == null) {
            return;
        }
        this.selectedDataObject = null;
        String fileName = this.fileNameTextField.getText();
        if ("".equals(fileName)) {
            this.okButton.setEnabled(false);
            if (this.newButton != null) {
                this.newButton.setEnabled(!this.checkForDefaultBundle());
            }
        } else {
            FileObject fo;
            if (!fileName.toLowerCase().endsWith(PROPERTIES_EXT)) {
                fileName = fileName + PROPERTIES_EXT;
            }
            if ((fo = this.selectedFolder.getPrimaryFile().getFileObject(fileName)) != null) {
                try {
                    this.selectedDataObject = DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            this.okButton.setEnabled(this.selectedDataObject != null);
            if (this.newButton != null) {
                this.newButton.setEnabled(this.selectedDataObject == null);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }
}

