/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.logs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.profiler.snaptracer.logs.LogRecords;
import org.openide.filesystems.FileObject;

public final class LogReader {
    private static final Logger LOG = Logger.getLogger(LogRecords.class.getName());
    private FileObject logFile;
    private NavigableMap<Long, LogRecord> recordList;

    public LogReader(FileObject f) {
        this.logFile = f;
        this.recordList = new TreeMap<Long, LogRecord>();
    }

    public void load() throws IOException {
        BufferedInputStream is = new BufferedInputStream(this.logFile.getInputStream(), 32768);
        try {
            LogRecords.scan(is, new LogHandler());
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public LogRecord getRecordFor(long time) {
        Map.Entry<Long, LogRecord> entry = this.recordList.floorEntry(new Long(time));
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    class LogHandler
    extends Handler {
        LogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            LogReader.this.recordList.put(new Long(record.getMillis()), record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

