/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class SourceUtils {
    private SourceUtils() {
    }

    public static TypeElement getPublicTopLevelElement(CompilationController controller) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        FileObject mainFileObject = controller.getFileObject();
        if (mainFileObject == null) {
            throw new IllegalStateException();
        }
        String mainElementName = mainFileObject.getName();
        List elements = controller.getTopLevelElements();
        if (elements != null) {
            for (TypeElement element : elements) {
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || !element.getSimpleName().contentEquals(mainElementName)) continue;
                return element;
            }
        }
        return null;
    }

    public static ClassTree getPublicTopLevelTree(CompilationController controller) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        TypeElement typeElement = SourceUtils.getPublicTopLevelElement(controller);
        if (typeElement != null) {
            return controller.getTrees().getTree(typeElement);
        }
        return null;
    }

    public static boolean isSubtype(CompilationController controller, TypeElement subtype, String supertype) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        Parameters.notNull((CharSequence)"subtype", (Object)subtype);
        Parameters.notNull((CharSequence)"supertype", (Object)supertype);
        TypeMirror typeMirror = controller.getTreeUtilities().parseType(supertype, subtype);
        if (typeMirror != null) {
            return controller.getTypes().isSubtype(subtype.asType(), typeMirror);
        }
        return false;
    }

    static TypeElement classTree2TypeElement(CompilationController controller, ClassTree classTree) {
        assert (controller != null);
        assert (classTree != null);
        TreePath classTreePath = controller.getTrees().getPath(controller.getCompilationUnit(), classTree);
        return (TypeElement)controller.getTrees().getElement(classTreePath);
    }

    static ExecutableElement getNoArgConstructor(CompilationController controller, TypeElement typeElement) {
        assert (controller != null);
        assert (typeElement != null);
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (constructor = (ExecutableElement)element).getParameters().size() != 0 || controller.getElementUtilities().isSynthetic((Element)constructor)) continue;
            return constructor;
        }
        return null;
    }

    public static FileObject getFileObject(final String className, ClasspathInfo cpInfo) throws IOException {
        final FileObject[] result = new FileObject[]{null};
        JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElem = cc.getElements().getTypeElement(className);
                if (typeElem != null) {
                    result[0] = org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElem), (ClasspathInfo)cc.getClasspathInfo());
                }
            }
        }, true);
        return result[0];
    }
}

