/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.properties.Token;

public final class Tokenizer {
    private List<Token> tokens;
    private int currentToken;

    private Tokenizer(List<Token> tokens, CharSequence input) {
        this.tokens = tokens;
    }

    public Tokenizer(CharSequence input) {
        this(Tokenizer.tokenize(input), input);
        this.reset();
    }

    public List<Token> tokensList() {
        return this.tokens;
    }

    public int tokenIndex() {
        return this.currentToken;
    }

    public int tokensCount() {
        return this.tokens.size();
    }

    public void move(int tokenIndex) {
        this.currentToken = tokenIndex;
    }

    public void reset() {
        this.currentToken = -1;
    }

    public Token token() {
        if (this.currentToken == -1) {
            this.currentToken = 0;
        }
        if (this.currentToken >= this.tokens.size()) {
            return null;
        }
        return this.tokens.get(this.currentToken);
    }

    public boolean moveNext() {
        if (this.currentToken < this.tokens.size() - 1) {
            ++this.currentToken;
            return true;
        }
        return false;
    }

    public boolean movePrevious() {
        if (this.currentToken >= 0) {
            --this.currentToken;
            return this.currentToken != -1;
        }
        return false;
    }

    private static List<Token> tokenize(CharSequence input) {
        LinkedList<Token> stack = new LinkedList<Token>();
        TokenHierarchy th = TokenHierarchy.create((CharSequence)input, CssTokenId.language());
        TokenSequence ts = th.tokenSequence(CssTokenId.language());
        ts.moveStart();
        block3: while (ts.moveNext()) {
            org.netbeans.api.lexer.Token t = ts.token();
            switch ((CssTokenId)t.id()) {
                case WS: 
                case NL: {
                    continue block3;
                }
            }
            stack.add(new Token((CssTokenId)t.id(), ts.offset(), t.length(), input));
        }
        return stack;
    }
}

