/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ReferenceType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.truffle.DebugManagerHandler;
import org.netbeans.modules.debugger.jpda.truffle.RemoteServices;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;

public class StepIntoScriptHandler
extends LazyActionsManagerListener
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(StepIntoScriptHandler.class.getCanonicalName());
    private static final String PROP_ACTION_TO_BE_RUN = "actionToBeRun";
    private final JPDADebugger debugger;
    private ClassType serviceClass;
    private Field steppingField;

    public StepIntoScriptHandler(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)new CurrentSFTracker());
    }

    protected void destroy() {
        LOG.fine("\nStepIntoJSHandler.destroy()");
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed", PROP_ACTION_TO_BE_RUN};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object action;
        if (PROP_ACTION_TO_BE_RUN.equals(evt.getPropertyName()) && ActionsManager.ACTION_STEP_INTO.equals(action = evt.getNewValue())) {
            ClassObjectReference serviceClassRef = RemoteServices.getServiceClass(this.debugger);
            LOG.log(Level.FINE, "StepIntoScriptHandler.actionToBeRun: {0}, serviceClassRef = {1}", new Object[]{action, serviceClassRef});
            if (serviceClassRef != null) {
                try {
                    this.serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassRef);
                    this.steppingField = ReferenceTypeWrapper.fieldByName((ReferenceType)this.serviceClass, (String)"steppingIntoTruffle");
                    this.serviceClass.setValue(this.steppingField, this.serviceClass.virtualMachine().mirrorOf(1));
                    RemoteServices.interruptServiceAccessThread(this.debugger);
                    LOG.fine("StepIntoScriptHandler: isSteppingInto set to true.");
                }
                catch (ClassNotLoadedException | InvalidTypeException | ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {}
            } else {
                DebugManagerHandler.execStepInto(this.debugger, true);
            }
        }
    }

    private class CurrentSFTracker
    implements PropertyChangeListener {
        private CurrentSFTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() == null) {
                return;
            }
            LOG.fine("Current frame changed>");
            if (StepIntoScriptHandler.this.steppingField != null) {
                try {
                    StepIntoScriptHandler.this.serviceClass.setValue(StepIntoScriptHandler.this.steppingField, StepIntoScriptHandler.this.serviceClass.virtualMachine().mirrorOf(-1));
                    StepIntoScriptHandler.this.steppingField = null;
                    RemoteServices.interruptServiceAccessThread(StepIntoScriptHandler.this.debugger);
                    LOG.fine("StepIntoScriptHandler: isSteppingInto set to false.");
                }
                catch (ClassNotLoadedException | InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                DebugManagerHandler.execStepInto(StepIntoScriptHandler.this.debugger, false);
            }
        }
    }
}

