/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class SessionsTableModelFilter
implements TableModelFilter,
Constants,
PropertyChangeListener {
    private Vector listeners = new Vector();
    private boolean addedAsListener;
    private static final Integer SD = new Integer(4);

    private static String loc(String key) {
        return NbBundle.getBundle(SessionsTableModelFilter.class).getString(key);
    }

    public Object getValueAt(TableModel original, Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Session && SessionsTableModelFilter.isJPDASession((Session)row)) {
            if ("SessionState".equals(columnID)) {
                return this.getSessionState((Session)row);
            }
            if ("SessionLanguage".equals(columnID)) {
                return row;
            }
            if ("SessionHostName".equals(columnID)) {
                return ((Session)row).getLocationName();
            }
            throw new UnknownTypeException(row);
        }
        return original.getValueAt(row, columnID);
    }

    public boolean isReadOnly(TableModel original, Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Session && SessionsTableModelFilter.isJPDASession((Session)row)) {
            if ("SessionState".equals(columnID)) {
                return true;
            }
            if ("SessionLanguage".equals(columnID)) {
                return false;
            }
            if ("SessionHostName".equals(columnID)) {
                return true;
            }
            throw new UnknownTypeException(row);
        }
        return original.isReadOnly(row, columnID);
    }

    public void setValueAt(TableModel original, Object row, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(row, columnID, value);
    }

    static boolean isJPDASession(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return false;
        }
        JPDADebugger d = (JPDADebugger)e.lookupFirst(null, JPDADebugger.class);
        return d != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionState(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return SessionsTableModelFilter.loc("MSG_Session_State_Starting");
        }
        JPDADebugger d = (JPDADebugger)e.lookupFirst(null, JPDADebugger.class);
        SessionsTableModelFilter sessionsTableModelFilter = this;
        synchronized (sessionsTableModelFilter) {
            if (!this.addedAsListener) {
                d.addPropertyChangeListener("state", (PropertyChangeListener)this);
            }
        }
        switch (d.getState()) {
            case 4: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Disconnected");
            }
            case 2: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Running");
            }
            case 1: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Starting");
            }
            case 3: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Stopped");
            }
        }
        return null;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.fireTreeChanged();
        if (e.getNewValue().equals(SD)) {
            ((JPDADebugger)e.getSource()).removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
    }
}

