/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.language;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class ClassnameCompletionItem
implements CompletionItem {
    private final String text;
    private final String sortPrefix;
    private final int caret;
    private final int correction;
    private final String pkgName;
    private final String typeName;
    private static final Color fieldColor = Color.decode("0xa38000");

    public ClassnameCompletionItem(String sortPrefix, String text, int caretOffset) {
        this(sortPrefix, text, caretOffset, 0);
    }

    public ClassnameCompletionItem(String sortPrefix, String text, int caretOffset, int correction) {
        this.text = text;
        this.caret = caretOffset;
        this.correction = correction;
        this.sortPrefix = sortPrefix;
        int pkgPos = text.lastIndexOf(46);
        if (pkgPos > -1) {
            this.pkgName = text.substring(0, pkgPos);
            this.typeName = text.substring(pkgPos + 1);
        } else {
            this.pkgName = "";
            this.typeName = text;
        }
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public void defaultAction(JTextComponent component) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        doc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                try {
                    doc.remove(ClassnameCompletionItem.this.caret, ClassnameCompletionItem.this.correction);
                    doc.insertString(ClassnameCompletionItem.this.caret, ClassnameCompletionItem.this.text, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        Completion.get().hideAll();
    }

    public CharSequence getInsertPrefix() {
        return this.text;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)(this.typeName + " (" + this.text + ")"), null, (Graphics)g, (Font)defaultFont);
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return this.sortPrefix + "_" + this.text;
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml(null, (String)("<b>" + this.typeName + "</b> <i>(" + this.text + ")</i>"), null, (Graphics)g, (Font)defaultFont, (Color)(selected ? Color.white : fieldColor), (int)width, (int)height, (boolean)selected);
    }
}

